% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainCode.R
\name{olbm}
\alias{olbm}
\title{Fitting OLBM to the data}
\usage{
olbm(Y, Q, L, init = "kmeans", eps = 1e-04, it_max = 500,
  verbose = TRUE)
}
\arguments{
\item{Y}{An M x P ordinal matrix, containing ordinal entries from 1 to K. Missing data are coded as zeros.}

\item{Q}{The number of row clusters.}

\item{L}{The number of column clusters.}

\item{init}{A string specifying the initialisation type. It can be "kmeans" (the default) or "random" for a single random initialisation.}

\item{eps}{When the difference between two consecutive vaules of the log-likelihood is smaller than eps, the M-EM algorithms will stop.}

\item{it_max}{The maximum number of iterations that the M-EM algorithms will perform (although the minimum tolerance eps is not reached).}

\item{verbose}{A boolean specifying whether extended information should be displayed or not (TRUE by default).}
}
\value{
It returns an S3 object of class "olbm" containing 
          \item{estR}{the estimated row cluster memberships.}
          \item{estC}{the estimated column cluster memberships.}
          \item{likeli}{the final value of the log-likelihood.}
          \item{icl}{the value of the ICL criterion.}
          \item{Pi}{the Q x L estimated connectivity matrix.}
          \item{mu}{a Q x L matrix containing the estimated means of the latent Gaussian distributions.}
          \item{sd}{a Q x L matrix containing the estimated standard deviations of the latent Gaussian distributions.}
          \item{eta}{a Q x L x K array whose entry (q,l,k) is the estimated probability that one user in the q-th row cluster assign the score k to one product in the l-th column cluster.}
          \item{rho}{the estimated row cluster proportions.}
          \item{delta}{the estimated column cluster proportions.}
          \item{initR}{the initial row cluster assignments provided to the C-EM algorithm.}
          \item{initC}{the initial column cluter assignments provided to the C-EM algorigthm.}
          \item{Y}{the input ordinal matrix Y.}
          \item{thresholds}{the values (1.5, 2.5, ... , K-0.5) of the thresholds, defined inside the function olbm.}
}
\description{
It estimates the OLBM model parameters as well as the most likely posterior cluster assignments by maximum likelihood.
}
\examples{

data(olbm_dat)
res <- olbm(olbm_dat$Y, Q=3, L=2)                       
}
\references{
Corneli M.,Bouveyron C. and Latouche P. (2019) \emph{Co-Clustering of ordinal data via latent continuous random variables and a classification EM algorithm. }(\url{https://hal.archives-ouvertes.fr/hal-01978174})
}
