% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mort_funs.R
\name{recruits_at_time}
\alias{recruits_at_time}
\title{Calculate the number of recruits left after given time based on mortality}
\usage{
recruits_at_time(
  time_at_stocking,
  time_at_rec,
  fish_init,
  mort_fun = exp_mort,
  mort_fun_args
)
}
\arguments{
\item{time_at_stocking}{The day that fish are stocked (i.e. synonymous with
the amount of time that fish are raised in a hatchery)}

\item{time_at_rec}{The time at which a fish enters the fishery (i.e. the
amount of time it takes a fish to grow to a desired length). Use
\code{\link{inv_vb}} to calculate this.}

\item{fish_init}{The initial number of fish stocked}

\item{mort_fun}{The mortality function, see ?mort_funs}

\item{mort_fun_args}{List. Named arguments to be passed to \code{mort_fun}}
}
\value{
The number of fish that will be left given the mortality function,
its parameters, and the time (\code{time_at_rec} - \code{time_at_stocking})
}
\description{
This function will use the provided mortality function and parameters along
with the length of time from stocking until the time in question to determine
how many fish will be left at that time (i.e. how many fish die between
\code{time_at_stocking} and \code{time_at_rec}).
}
\details{
This function calculates how many fish are left at a certain time based on
the initial number of fish stocked and the integral of the mortality
function. The number of fish left are computed using the following equation:

\ifelse{html}{
  \out{N<sub>t</sub> = N<sub>0</sub> exp(&int; f(t))}
}{
  \deqn{N_t = N_0 \exp{\int_{T=0}^{t}f(t)}}
}

where \ifelse{html}{\out{N<sub>0</sub>}}{\deqn{N_0}} is the initial number of fish
stocked and f(t) is the mortality function. The amount of time is provided
to the function as the time at which fish are recruited into the fishery
minus the time at which they are stocked. The time at which fish are
recruited into the fishery can be calculated using the inverse von
Bertalanffy growth function (see \code{\link{inv_vb}}).
}
\examples{
mort_args <- list(
  m_init = (1 / 365),
  m_inf = (0.2/365),
  alpha = 0.005
)
recruits_at_time(100, 1000, 1000,
                 mort_fun = exp_mort,
                 mort_fun_args = mort_args)
}
