% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLevelConstant.R
\name{getLevelConstant}
\alias{getLevelConstant}
\title{Get Level Constant for Optimal Conditional Error Function}
\usage{
getLevelConstant(design)
}
\arguments{
\item{design}{An object of class \code{TrialDesignOptimalConditionalError} created by \code{getDesignOptimalConditionalErrorFunction()}. Contains all necessary arguments to calculate the optimal conditional error function for the specified case.}
}
\value{
A list that contains the constant (element \code{$root}) and other components provided by \code{uniroot()}.
The level constant is calculated corresponding to the mean difference scale.
}
\description{
Find the constant required such that the conditional error function meets the overall level condition.
}
\details{
The level condition is defined as:
\deqn{\alpha = \alpha_1 + \int_{\alpha_1}^{\alpha_0} \alpha_2(p_1)dp_1.}
The constant \eqn{c_0} of the optimal conditional error function is calibrated such that it meets the level condition.
For a valid design, the additional following condition must be met to be able to exhaust the level \eqn{\alpha}:
\deqn{\alpha_1 + CP(\alpha_0-\alpha_1)>\alpha.}
This condition is checked by \code{getLevelConstant()} and the execution is terminated if it is not met. \cr
In case a conditional power function is used, the condition is instead:
\deqn{\alpha_1 + \int_{\alpha_1}^{\alpha_0} CP(p_1)dp_1>\alpha.}
}
\references{
Brannath, W. & Bauer, P. (2004). Optimal conditional error functions for the control of conditional power. Biometrics. https://www.jstor.org/stable/3695393

Brannath, W., Dreher, M., zur Verth, J., Scharpenberg, M. (2024). Optimal monotone conditional error functions. https://arxiv.org/abs/2402.00814
}
