% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochrones.R
\name{ors_isochrones}
\alias{ors_isochrones}
\title{Openrouteservice Isochrones}
\usage{
ors_isochrones(
  locations,
  profile = ors_profile(),
  range = 60,
  ...,
  api_key = ors_api_key(),
  output = c("parsed", "text", "sf")
)
}
\arguments{
\item{locations}{List of \verb{longitude, latitude} coordinate pairs, alternatively a two column \code{matrix} or \code{data.frame}.}

\item{profile}{Route profile, defaults to \code{"driving-car"}.}

\item{range}{Maximum range value of the analysis in seconds for time and
meters for distance. Alternatively a comma separated list of specific
single range values.}

\item{...}{Optional parameters as described \href{https://openrouteservice.org/dev/#/api-docs/v2/isochrones/{profile}/post}{here}}

\item{api_key}{Character scalar containing openrouteservice API key}

\item{output}{Output format. By default the response is being parsed to a list-based R object}
}
\value{
A GeoJSON object containing a FeatureCollection of Polygons

\itemize{
\item for \code{"text"}, a character vector of length 1 re-encoded to UTF-8.
}

\itemize{
\item for \code{"parsed"}, a parsed R object.
}

\itemize{
\item for \code{"sf"}, a simple features \code{\link[sf]{sf}} object.
}
}
\description{
Obtain areas of reachability from given locations.
}
\details{
The Isochrone Service supports time and distance analyses for one single or
multiple locations. You may also specify the isochrone interval or provide
multiple exact isochrone range values.
}
\examples{
# These examples might require interaction to query the local keyring, or
# might fail due to network issues, so they are not run by default
\dontrun{
ors_isochrones(c(8.34234, 48.23424), interval=20)

locations <- list(c(8.681495, 49.41461), c(8.686507,49.41943))
ors_isochrones(locations, range=c(300, 200))
}
}
\author{
Andrzej Oleś \href{mailto:andrzej.oles@gmail.com}{andrzej.oles@gmail.com}
}
