% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traj_trajMap.R
\name{trajMap}
\alias{trajMap}
\title{Trajectory line plots in \code{leaflet}}
\usage{
trajMap(
  data,
  longitude = "lon",
  latitude = "lat",
  colour = NULL,
  type = NULL,
  cols = "default",
  alpha = 0.5,
  npoints = 12,
  provider = "OpenStreetMap",
  legend.position = "topright",
  legend.title = NULL,
  legend.title.autotext = TRUE,
  control.collapsed = FALSE,
  control.position = "topright",
  control = NULL,
  ...
)
}
\arguments{
\item{data}{\emph{A data frame containing a HYSPLIT trajectory, perhaps accessed
with \code{\link[openair:importTraj]{openair::importTraj()}}.}

\strong{required}

A data frame containing HYSPLIT model outputs. If this data were not
obtained using \code{\link[openair:importTraj]{openair::importTraj()}}.}

\item{latitude, longitude}{\emph{The decimal latitude/longitude.}

\emph{default:} \code{"lat"} / \code{"lon"}

Column names representing the decimal latitude and longitude.}

\item{colour}{\emph{Column to be used for colouring each trajectory.}

\emph{default:} \code{NULL}

This column may be numeric, character, factor or date(time). This will
commonly be a pollutant concentration which has been joined (e.g., by
\code{\link[dplyr:mutate-joins]{dplyr::left_join()}}) to the trajectory data by "date".}

\item{type}{\emph{A method to condition the \code{data} for separate plotting.}

\emph{default:} \code{NULL}

Used for splitting the trajectories into different groups which can be
selected between using a "layer control" menu. Passed to
\code{\link[openair:cutData]{openair::cutData()}}.}

\item{cols}{\emph{Colours to use for plotting.}

\emph{default:} \code{"default"}

The colours used for plotting, passed to \code{\link[openair:openColours]{openair::openColours()}}.}

\item{alpha}{\emph{Transparency value for trajectories.}

\emph{default:} \code{1}

A value between \code{0} (fully transparent) and \code{1} (fully opaque).}

\item{npoints}{\emph{Interval at which points are placed along the trajectory
paths.}

\emph{default:} \code{12}

A dot is placed every \code{npoints} along each full trajectory. For hourly back
trajectories points are plotted every \code{npoints} hours. This helps to
understand where the air masses were at particular times and get a feel for
the speed of the air (points closer together correspond to slower moving
air masses). Defaults to \code{12}.}

\item{provider}{\emph{The basemap to be used.}

\emph{default:} \code{"OpenStreetMap"}

A single \link[leaflet:providers]{leaflet::providers}. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list of
all base maps that can be used.}

\item{legend.position}{\emph{Position of the shared legend.}

\emph{default:} \code{"topright"}

Where should the legend be placed? One of "topright", "topright",
"bottomleft" or "bottomright". Passed to the \code{position} argument of
\code{\link[leaflet:addLegend]{leaflet::addLegend()}}. \code{NULL} defaults to "topright".}

\item{legend.title}{\emph{Title of the legend.}

\emph{default:} \code{NULL}

By default, when \code{legend.title = NULL}, the function will attempt to
provide a sensible legend title based on \code{colour}. \code{legend.title} allows
users to overwrite this - for example, to include units or other contextual
information. Users may wish to use HTML tags to format the title.}

\item{legend.title.autotext}{\emph{Automatically format the title of the legend?}

\emph{default:} \code{TRUE}

When \code{legend.title.autotext = TRUE}, \code{legend.title} will be first run
through \code{\link[=quickTextHTML]{quickTextHTML()}}.}

\item{control.collapsed}{\emph{Show the layer control as a collapsed?}

\emph{default:} \code{FALSE}

Should the "layer control" interface be collapsed? If \code{TRUE}, users will
have to hover over an icon to view the options.}

\item{control.position}{\emph{Position of the layer control menu}

\emph{default:} \code{"topright"}

Where should the "layer control" interface be placed? One of "topleft",
"topright", "bottomleft" or "bottomright". Passed to the \code{position}
argument of \code{\link[leaflet:addLayersControl]{leaflet::addLayersControl()}}.}

\item{control}{Deprecated. Please use \code{type}.}

\item{...}{
  Arguments passed on to \code{\link[openair:cutData]{openair::cutData}}
  \describe{
    \item{\code{hemisphere}}{Can be \code{"northern"} or \code{"southern"}, used to
split data into seasons.}
    \item{\code{n.levels}}{Number of quantiles to split numeric data into.}
    \item{\code{start.day}}{What day of the week should the \code{type = "weekday"}
start on?  The user can change the start day by supplying an integer
between 0 and 6. Sunday = 0, Monday = 1, \ldots For example to start the
weekday plots on a Saturday, choose \code{start.day = 6}.}
    \item{\code{is.axis}}{A logical (\code{TRUE}/\code{FALSE}), used to request
shortened cut labels for axes.}
    \item{\code{local.tz}}{Used for identifying whether a date has daylight savings time
(DST) applied or not. Examples include \code{local.tz = "Europe/London"},
\code{local.tz = "America/New_York"} i.e. time zones that assume DST.
\url{https://en.wikipedia.org/wiki/List_of_zoneinfo_time_zones} shows time
zones that should be valid for most systems. It is important that the
original data are in GMT (UTC) or a fixed offset from GMT. See
\code{import} and the openair manual for information on how to import data
and ensure no DST is applied.}
  }}
}
\value{
A leaflet object.
}
\description{
This function plots back trajectories on a \code{leaflet} map. This function
requires that data are imported using the \code{\link[openair:importTraj]{openair::importTraj()}} function.
Options are provided to colour the individual trajectories (e.g., by
pollutant concentrations) or create "layer control" menus to show/hide
different layers.
}
\examples{
\dontrun{
trajMap(traj_data, colour = "pm10")
}

}
\seealso{
\code{\link[openair:trajPlot]{openair::trajPlot()}}

\code{\link[=trajMapStatic]{trajMapStatic()}} for the static \code{ggplot2} equivalent of \code{\link[=trajMap]{trajMap()}}

Other interactive trajectory maps: 
\code{\link{trajLevelMap}()}
}
\concept{interactive trajectory maps}
