% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_pccs.R
\name{plot.opaHypothesisComparison}
\alias{plot.opaHypothesisComparison}
\title{Plot hypothesis comparison PCC replicates.}
\usage{
\method{plot}{opaHypothesisComparison}(x, ...)
}
\arguments{
\item{x}{an object of class "oparandpccs" produced by \code{random_pccs()}}

\item{...}{ignored}
}
\value{
no return value, called for side effects only.
}
\description{
Plot hypothesis comparison PCC replicates.
}
\details{
Plot a histogram of PCCs computed from randomly reordered data
used to calculate the chance-value for a hypothesis comparison.
}
\examples{
dat <- data.frame(t1 = c(9, 4, 8, 10),
                  t2 = c(8, 8, 12, 10),
                  t3 = c(8, 5, 10, 11),
                  t4 = c(10, 5, 11, 12))
h1 <- hypothesis(c(1, 2, 3, 4))
h2 <- hypothesis(c(1, 4, 2, 3))
opamod1 <- opa(dat, h1)
opamod2 <- opa(dat, h2)
z <- compare_hypotheses(opamod1, opamod2)
plot(z)
}
