% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omophub-package.R
\docType{package}
\name{omophub-package}
\alias{omophub-package}
\alias{omophub}
\title{omophub: R Client for the 'OMOPHub' Medical Vocabulary API}
\description{
Provides an R interface to the 'OMOPHub' API for accessing 'OHDSI ATHENA' standardized medical vocabularies. Supports concept search, vocabulary exploration, hierarchy navigation, relationship queries, and concept mappings with automatic pagination and rate limiting.

Provides an R interface to the OMOPHub API for accessing OHDSI ATHENA
standardized medical vocabularies. Supports concept search, vocabulary
exploration, hierarchy navigation, relationship queries, and concept
mappings with automatic pagination and rate limiting.
}
\section{Main Client}{

The main entry point is the \link{OMOPHubClient} R6 class which provides
access to all API resources:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(omophub)
client <- OMOPHubClient$new()

# Search for concepts
results <- client$search$basic("diabetes")

# Get a specific concept
concept <- client$concepts$get(201826)
}\if{html}{\out{</div>}}
}

\section{Authentication}{

Set your API key using one of these methods:
\itemize{
\item Environment variable: \code{OMOPHUB_API_KEY}
\item Explicit argument: \code{OMOPHubClient$new(api_key = "your_key")}
\item Keyring: \code{set_api_key("your_key", store = "keyring")}
}
}

\section{Resources}{

The client provides access to these resources:
\itemize{
\item \code{concepts}: Concept lookup and batch operations
\item \code{search}: Basic and advanced concept search
\item \code{vocabularies}: Vocabulary listing and details
\item \code{domains}: Domain listing and concept filtering
\item \code{hierarchy}: Ancestor and descendant navigation
\item \code{relationships}: Concept relationships
\item \code{mappings}: Concept mappings between vocabularies
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/omopHub/omophub-R}
  \item \url{https://docs.omophub.com}
  \item \url{https://omophub.github.io/omophub-R/}
  \item \url{https://omophub.com}
  \item Report bugs at \url{https://github.com/omopHub/omophub-R/issues}
}

}
\author{
\strong{Maintainer}: Alex Chen \email{alex@omophub.com} [copyright holder]

Other contributors:
\itemize{
  \item Observational Health Data Science and Informatics [copyright holder]
}

}
\keyword{internal}
