% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocabularies.R
\name{VocabulariesResource}
\alias{VocabulariesResource}
\title{Vocabularies Resource}
\value{
Paginated vocabulary list.

Vocabulary details including vocabulary_id, vocabulary_name,
vocabulary_reference, vocabulary_version, vocabulary_concept_id.

Vocabulary statistics.

Domain statistics including concept counts and class breakdown.

List of all available domains with domain_id, domain_name, and description.

List of all available concept classes with concept_class_id,
concept_class_name, and concept_class_concept_id.

Paginated concepts.
}
\description{
R6 class providing access to vocabulary operations.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VocabulariesResource-new}{\code{VocabulariesResource$new()}}
\item \href{#method-VocabulariesResource-list}{\code{VocabulariesResource$list()}}
\item \href{#method-VocabulariesResource-get}{\code{VocabulariesResource$get()}}
\item \href{#method-VocabulariesResource-stats}{\code{VocabulariesResource$stats()}}
\item \href{#method-VocabulariesResource-domain_stats}{\code{VocabulariesResource$domain_stats()}}
\item \href{#method-VocabulariesResource-domains}{\code{VocabulariesResource$domains()}}
\item \href{#method-VocabulariesResource-concept_classes}{\code{VocabulariesResource$concept_classes()}}
\item \href{#method-VocabulariesResource-concepts}{\code{VocabulariesResource$concepts()}}
\item \href{#method-VocabulariesResource-print}{\code{VocabulariesResource$print()}}
\item \href{#method-VocabulariesResource-clone}{\code{VocabulariesResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VocabulariesResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-VocabulariesResource-new}{}}}
\subsection{Method \code{new()}}{
Create a new VocabulariesResource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VocabulariesResource$new(base_req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_req}}{Base httr2 request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VocabulariesResource-list"></a>}}
\if{latex}{\out{\hypertarget{method-VocabulariesResource-list}{}}}
\subsection{Method \code{list()}}{
List all vocabularies.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VocabulariesResource$list(
  include_stats = FALSE,
  include_inactive = FALSE,
  sort_by = "name",
  sort_order = "asc",
  page = 1,
  page_size = 100
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include_stats}}{Include vocabulary statistics. Default \code{FALSE}.}

\item{\code{include_inactive}}{Include inactive vocabularies. Default \code{FALSE}.}

\item{\code{sort_by}}{Sort field ("name", "priority", "updated"). Default "name".}

\item{\code{sort_order}}{Sort order ("asc" or "desc"). Default "asc".}

\item{\code{page}}{Page number. Default 1.}

\item{\code{page_size}}{Results per page. Default 100.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VocabulariesResource-get"></a>}}
\if{latex}{\out{\hypertarget{method-VocabulariesResource-get}{}}}
\subsection{Method \code{get()}}{
Get vocabulary details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VocabulariesResource$get(vocabulary_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vocabulary_id}}{The vocabulary ID.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VocabulariesResource-stats"></a>}}
\if{latex}{\out{\hypertarget{method-VocabulariesResource-stats}{}}}
\subsection{Method \code{stats()}}{
Get vocabulary statistics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VocabulariesResource$stats(vocabulary_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vocabulary_id}}{The vocabulary ID.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VocabulariesResource-domain_stats"></a>}}
\if{latex}{\out{\hypertarget{method-VocabulariesResource-domain_stats}{}}}
\subsection{Method \code{domain_stats()}}{
Get statistics for a specific domain within a vocabulary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VocabulariesResource$domain_stats(vocabulary_id, domain_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vocabulary_id}}{The vocabulary ID (e.g., "SNOMED", "ICD10CM").}

\item{\code{domain_id}}{The domain ID (e.g., "Condition", "Drug", "Procedure").}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VocabulariesResource-domains"></a>}}
\if{latex}{\out{\hypertarget{method-VocabulariesResource-domains}{}}}
\subsection{Method \code{domains()}}{
Get all standard OHDSI domains.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VocabulariesResource$domains()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VocabulariesResource-concept_classes"></a>}}
\if{latex}{\out{\hypertarget{method-VocabulariesResource-concept_classes}{}}}
\subsection{Method \code{concept_classes()}}{
Get all concept classes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VocabulariesResource$concept_classes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VocabulariesResource-concepts"></a>}}
\if{latex}{\out{\hypertarget{method-VocabulariesResource-concepts}{}}}
\subsection{Method \code{concepts()}}{
Get concepts in a vocabulary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VocabulariesResource$concepts(
  vocabulary_id,
  search = NULL,
  standard_concept = "all",
  include_invalid = FALSE,
  include_relationships = FALSE,
  include_synonyms = FALSE,
  sort_by = "name",
  sort_order = "asc",
  page = 1,
  page_size = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vocabulary_id}}{The vocabulary ID.}

\item{\code{search}}{Search term to filter concepts by name or code.}

\item{\code{standard_concept}}{Filter by standard concept status ('S', 'C', 'all'). Default "all".}

\item{\code{include_invalid}}{Include invalid or deprecated concepts. Default \code{FALSE}.}

\item{\code{include_relationships}}{Include concept relationships. Default \code{FALSE}.}

\item{\code{include_synonyms}}{Include concept synonyms. Default \code{FALSE}.}

\item{\code{sort_by}}{Sort field ('name', 'concept_id', 'concept_code'). Default "name".}

\item{\code{sort_order}}{Sort order ('asc' or 'desc'). Default "asc".}

\item{\code{page}}{Page number. Default 1.}

\item{\code{page_size}}{Results per page (max 1000). Default 20.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VocabulariesResource-print"></a>}}
\if{latex}{\out{\hypertarget{method-VocabulariesResource-print}{}}}
\subsection{Method \code{print()}}{
Print resource information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VocabulariesResource$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VocabulariesResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VocabulariesResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VocabulariesResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
