% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-classicBoot.R
\name{estimate_classic}
\alias{estimate_classic}
\title{Apply bootstrap to RAM-OP indicators using a classical estimator.}
\usage{
estimate_classic(
  x,
  w,
  statistic = bbw::bootClassic,
  indicators = c("demo", "food", "hunger", "adl", "disability", "mental", "dementia",
    "health", "oedema", "screening", "income", "wash", "visual", "misc"),
  params = get_variables(indicators),
  outputColumns = params,
  replicates = 399
)
}
\arguments{
\item{x}{Indicators dataset produced by \code{\link[=create_op]{create_op()}} with primary sampling
unit (PSU) in column named \emph{"psu"}.}

\item{w}{A data frame with primary sampling unit (PSU) in column named
\emph{"psu"} and survey weight (i.e. PSU population) in column named \emph{"pop"}.}

\item{statistic}{A function operating on data in \code{x}. Fixed to
\code{\link[bbw:bootClassic]{bbw::bootClassic()}} function for means.}

\item{indicators}{A character vector of indicator set names to estimate.
Indicator set names are \emph{"demo"}, \emph{"food"}, \emph{"hunger"}, \emph{"disability"},
\emph{"adl"}, \emph{"mental"}, \emph{"dementia"}, \emph{"health"}, \emph{"income"}, \emph{"wash"},
\emph{"visual"}, and \emph{"misc"}. Default is all indicator sets.}

\item{params}{Parameters (named columns in \code{x}) passed to the function
specified in \code{statistic}. This is equivalent to variables corresponding to
the indicator sets specified in \code{indicators}. The function
\code{\link[=get_variables]{get_variables()}} is used to specify these variables.}

\item{outputColumns}{Names of columns in output data frame. This defaults to
values specified in \code{params}.}

\item{replicates}{Number of bootstrap replicates}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} of boot estimates using \code{\link[bbw:bootClassic]{bbw::bootClassic()}}
mean function
}
\description{
Apply bootstrap to RAM-OP indicators using a classical estimator.
}
\examples{
test <- estimate_classic(
  x = indicators.ALL, w = testPSU, replicates = 9
)

test

}
