% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{shorten_olc}
\alias{shorten_olc}
\title{Shorten Full Open Location Codes}
\usage{
shorten_olc(olcs, lats, longs)
}
\arguments{
\item{olcs}{a vector of open location codes, generated with \code{\link{encode_olc}} or through
any other means.}

\item{lats}{a numeric vector of latitudes.}

\item{longs}{a numeric vector of longitudes, equivalent in size to \code{lats}.}
}
\description{
One of the things that makes OLCs useful is that they can shortened - you can trim
characters off them, saving space without substantially compromising the accuracy. \code{shorten_olc}
takes full-length OLCs (generated with \code{\link{encode_olc}} or any other way) and shortens them.
}
\examples{
#Encode an OLC and then shorten it
olc <- encode_olc(51.3708675,-1.217765625, 12)
validate_full(olc)
# [1] TRUE

olc <- shorten_olc(olc, 51.3708675,-1.217765625)
validate_short(olc)
# [1] TRUE

}
\seealso{
\code{\link{encode_olc}} to create full Open Location Codes.
}

