% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\name{subset,amsr-method}
\alias{subset,amsr-method}
\title{Subset an amsr Object}
\usage{
\S4method{subset}{amsr}(x, subset, ...)
}
\arguments{
\item{x}{an \linkS4class{amsr} object.}

\item{subset}{an expression indicating how to subset \code{x}.}

\item{...}{ignored.}
}
\value{
An \linkS4class{amsr} object.
}
\description{
Return a subset of a \linkS4class{amsr} object.
}
\details{
This function is used to subset data within an \linkS4class{amsr}
object by \code{longitude} or by \code{latitude}.  These two methods cannot
be combined in a single call, so two calls are required, as shown
in the Example.
}
\examples{
library(oce)
data(amsr) # see ?amsr for how to read and composite such objects
sub <- subset(amsr, -75 < longitude & longitude < -45)
sub <- subset(sub, 40 < latitude & latitude < 50)
plot(sub)
data(coastlineWorld)
lines(coastlineWorld[["longitude"]], coastlineWorld[["latitude"]])

}
\seealso{
Other things related to amsr data: 
\code{\link{[[,amsr-method}},
\code{\link{[[<-,amsr-method}},
\code{\link{amsr}},
\code{\link{amsr-class}},
\code{\link{composite,amsr-method}},
\code{\link{download.amsr}()},
\code{\link{plot,amsr-method}},
\code{\link{read.amsr}()},
\code{\link{summary,amsr-method}}

Other functions that subset oce objects: 
\code{\link{subset,adp-method}},
\code{\link{subset,adv-method}},
\code{\link{subset,argo-method}},
\code{\link{subset,cm-method}},
\code{\link{subset,coastline-method}},
\code{\link{subset,ctd-method}},
\code{\link{subset,echosounder-method}},
\code{\link{subset,lobo-method}},
\code{\link{subset,met-method}},
\code{\link{subset,oce-method}},
\code{\link{subset,odf-method}},
\code{\link{subset,rsk-method}},
\code{\link{subset,sealevel-method}},
\code{\link{subset,section-method}},
\code{\link{subset,topo-method}},
\code{\link{subset,xbt-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset oce objects}
\concept{things related to amsr data}
