% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.saiv.R
\name{read.ctd.saiv}
\alias{read.ctd.saiv}
\title{Read a ctd File in SAIV Format}
\usage{
read.ctd.saiv(
  file,
  encoding = "latin1",
  debug = getOption("oceDebug"),
  processingLog,
  ...
)
}
\arguments{
\item{file}{a character string naming the file to be read.}

\item{encoding}{a character value that indicates the encoding to be used for
this data file, if it is textual.  The default value for most functions is
\code{"latin1"}, which seems to be suitable for files containing text written in
English and French.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}

\item{processingLog}{ignored.}

\item{...}{ignored.}
}
\value{
\code{\link[=read.ctd.saiv]{read.ctd.saiv()}} returns a \linkS4class{ctd} object.
}
\description{
\code{\link[=read.ctd.saiv]{read.ctd.saiv()}} reads files that hold data acquired with a
SAIV model SD204 CTD profiler (reference 1). Since no
documentation on the format was available to the author,
this function was written based on examination of a particular
data file.  This almost certainly will yield limitations
for other files, in particular for those with data names
that differ from those in the sample file (see
\dQuote{Details} for this and other limitations).
}
\details{
Some variable names are change to the oce convention, e.g.
\code{"Sal."} becomes \code{"salinity"}, \code{"Temp"} becomes
\code{"temperature"}, etc.  In the first version of the code,
this renaming was done based on examination of a single file.
This list was expanded after a user kindly supplied a one-page
document that explains the variable names and units. As with
other functions for reading \linkS4class{oce} data, \code{\link[=read.ctd.saiv]{read.ctd.saiv()}}
resolves duplicate variable names by appending 2 to the second
instance, 3 to the third, etc.

As with other \linkS4class{ctd} objects, the \code{[[} operator handles
both the original name from the file, and the converted oce
name.

It is worth noting the following oddities that were present
in the sample file upon which \code{\link[=read.ctd.saiv]{read.ctd.saiv()}} was based.
\enumerate{
\item The header line that names the data columns ends with a tab,
indicating the presence of 12 columns (the last unnamed), but the
data contain only 11 columns.  Therefore, the last tab character is
ignored by \code{\link[=read.ctd.saiv]{read.ctd.saiv()}}.
\item The test file lacked longitude and latitude information.  This
means that modern quantities like Absolute Salinity and Conservative
Temperature cannot be computed.  Users who know the location information
ought to insert values into the object returned by \code{\link[=read.ctd.saiv]{read.ctd.saiv()}}
using \code{\link[=oceSetMetadata]{oceSetMetadata()}}.
\item Further to the previous point, it is not possible to compute pressure
accurately from depth (which is what the header suggests the file
contains) unless the latitude is known. In \code{\link[=read.ctd.saiv]{read.ctd.saiv()}},
latitude is assumed to be 45 degrees north, which is the default
used by \code{\link[=swPressure]{swPressure()}}.
}
}
\references{
\enumerate{
\item \verb{https://saiv.no/sd204-ctd-profiler}
}
}
\seealso{
Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd}},
\code{\link{ctd-class}},
\code{\link{ctd.cnv.gz}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdFindProfilesRBR}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv.gz}},
\code{\link{d200321-001.ctd.gz}},
\code{\link{d201211_0011.cnv.gz}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.ssda}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}

Other functions that read ctd data: 
\code{\link{read.ctd}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.ssda}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd.woce.other}()}
}
\author{
Dan Kelley, with help from the github member with
the handle 'Rdescoteaux', who kindly supplied a sample file
and a document listing SAIV variable names.
}
\concept{functions that read ctd data}
\concept{things related to ctd data}
