% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\name{read.amsr}
\alias{read.amsr}
\title{Read an amsr File}
\usage{
read.amsr(file, encoding = NA, debug = getOption("oceDebug"))
}
\arguments{
\item{file}{String indicating the name of a compressed file. See
\dQuote{File sources}.}

\item{encoding}{ignored.}

\item{debug}{A debugging flag, integer.}
}
\description{
Read an amsr file, generating an \linkS4class{amsr} object.
Two file types are handled: type 1 is from gzipped files that were available
until perhaps the year 2022, and type 2 is from NetCDF files that
were available afterwards.
The type is stored in the \code{metadata} slot
as \code{type}, and this is detected in other functions relating to
\linkS4class{amsr} data.  The best way to locate amsr files is to use
\code{\link[=download.amsr]{download.amsr()}}, but if this fails, it may be necessary to search
the web for a source.
}
\seealso{
\code{\link[=plot,amsr-method]{plot,amsr-method()}} for an example.

Other things related to amsr data: 
\code{\link{[[,amsr-method}},
\code{\link{[[<-,amsr-method}},
\code{\link{amsr}},
\code{\link{amsr-class}},
\code{\link{composite,amsr-method}},
\code{\link{download.amsr}()},
\code{\link{plot,amsr-method}},
\code{\link{subset,amsr-method}},
\code{\link{summary,amsr-method}}
}
\author{
Dan Kelley and Chantelle Layton
}
\concept{things related to amsr data}
