% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{as.section}
\alias{as.section}
\title{Create a Section}
\usage{
as.section(
  salinity,
  temperature,
  pressure,
  longitude,
  latitude,
  station,
  sectionId = "",
  debug = getOption("oceDebug")
)
}
\arguments{
\item{salinity}{This may be a numerical vector, in which case it is interpreted
as the salinity, and the other arguments are used for the other components of
\linkS4class{ctd} objects. Alternatively, it may be one of a variety of
other objects from which the CTD objects can be inferred, in which case the
other arguments are ignored; see \dQuote{Details}.}

\item{temperature}{Temperature, in a vector holding values for all stations.}

\item{pressure}{Pressure, in a vector holding values for all stations.}

\item{longitude}{Longitude, in a vector holding values for all stations.}

\item{latitude}{Latitude, in a vector holding values for all stations.}

\item{station}{Station identifiers, in a vector holding values for all stations.}

\item{sectionId}{Section identifier.}

\item{debug}{an integer value that controls whether \code{as.section()} prints information
during its work.  The function works quietly if this is 0 and prints out some
information if it is positive.}
}
\value{
An object of \linkS4class{section}.
}
\description{
Create a section based on columnar data, or a set of \linkS4class{oce}
objects that can be coerced to a section. There are three cases.
}
\details{
Case 1. If the first argument is a numerical vector, then it is taken to be the
salinity, and \code{\link[=factor]{factor()}} is applied to \code{station} to break the
data up into chunks that are assembled into \linkS4class{ctd} objects with
\code{\link[=as.ctd]{as.ctd()}} and combined to make a \linkS4class{section} object
to be returned. This mode of operation is provided as a convenience for datasets
that are already partly processed; if original CTD data are available, the next
mode is preferred, because it permits the storage of much more data and metadata
in the CTD object.

Case 2. If the first argument is a list containing oce objects, then those
objects are taken as profiles of something.  A requirement for this
to work is that every element of the list contains both \code{longitude}
and \code{latitude} in either the \code{metadata} or \code{data} slot (in
the latter case, the mean value is recorded in the section object)
and that every element also contains \code{pressure} in its \code{data} slot.

Case 3. If the first argument is a \linkS4class{argo} object, then
the profiles it contains are turned into \linkS4class{ctd} objects,
and these are assembled into a section to be returned.
}
\examples{
library(oce)
data(ctd)
# vector of names of CTD objects
fake <- ctd
fake[["temperature"]] <- ctd[["temperature"]] + 0.5
fake[["salinity"]] <- ctd[["salinity"]] + 0.1
fake[["longitude"]] <- ctd[["longitude"]] + 0.01
fake[["station"]] <- "fake"
sec1 <- as.section(c("ctd", "fake"))
summary(sec1)
# vector of CTD objects
ctds <- vector("list", 2)
ctds[[1]] <- ctd
ctds[[2]] <- fake
sec2 <- as.section(ctds)
summary(sec2)
# argo data (a subset)
data(argo)
sec3 <- as.section(subset(argo, profile < 5))
summary(sec3)

}
\seealso{
Other things related to section data: 
\code{\link{[[,section-method}},
\code{\link{[[<-,section-method}},
\code{\link{handleFlags,section-method}},
\code{\link{initializeFlagScheme,section-method}},
\code{\link{plot,section-method}},
\code{\link{read.section}()},
\code{\link{section}},
\code{\link{section-class}},
\code{\link{sectionAddStation}()},
\code{\link{sectionGrid}()},
\code{\link{sectionSmooth}()},
\code{\link{sectionSort}()},
\code{\link{subset,section-method}},
\code{\link{summary,section-method}}
}
\author{
Dan Kelley
}
\concept{things related to section data}
