% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/legendFunctions.R
\name{addLegend}
\alias{addLegend}
\title{Function for adding a legend to an existing device}
\usage{
addLegend(x = "center", y = NULL, legend, font = NULL, bty = "n",
  xjust = 0.5, yjust = 0.5, ...)
}
\arguments{
\item{x}{legend x location}

\item{y}{legend y location}

\item{legend}{vector of legend labels}

\item{font}{legend text font}

\item{bty}{A character string which determined the type of box which is drawn about plots. If bty is one of "o" (the default), "l", "7", "c", "u", or "]" the resulting box resembles the corresponding upper case letter. A value of "n" suppresses the box.}

\item{xjust}{how the legend is to be justified relative to the legend x location. A value of 0 means left justified, 0.5 means centered and 1 means right justified.}

\item{yjust}{the same as xjust for the legend y location.}

\item{...}{additional optional arguments to be passed to legend()}
}
\value{
none; legend is added to the current device
}
\description{
Function for adding a legend to an existing device
}
\examples{
layout <- c(2,3);
side <- "left"
proportion <- 0.2

prepLegend(layout = layout, side = side, proportion = proportion)
for(i in 1:(layout[1]*layout[2]))
	plot(1:7, 1:7, col = 1:7, pch = 19, cex = 2.2, xaxt = "n",
			yaxt = "n", ann = FALSE)
addLegend(legend = paste("Group", 1:7), font = 2,
		pch = 19, pt.cex = 2, text.col = 1:7, col = 1:7,
		y.intersp = 1.5, cex = 1.5)


layout = rbind(c(1, 2, 3), c(0, 4, 3), c(0, 4, 5))
side = "right"
proportion = 0.15

prepLegend(layout = layout, side = side, proportion = proportion)
for(i in 1:max(layout))
	plot(1:7, 1:7, col = 1:7, pch = 19, cex = 2.2, xaxt = "n",
			yaxt = "n", xlab = "", ylab = "", main = paste("Plot", i))
addLegend(legend = paste("Group", 1:7), font = 2,
		pch = 19, pt.cex = 2, text.col = 1:7, col = 1:7,
		y.intersp = 1.5, cex = 1.5)
}
\author{
Jason Waddell
}

