% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_entropy.R
\name{get_entropy}
\alias{get_entropy}
\title{Compute the entropy of transmission trees}
\usage{
get_entropy(out, normalise = TRUE)
}
\arguments{
\item{out}{A data frame of class \code{outbreaker_chains} containing posterior samples of transmission ancestries (alpha).}

\item{normalise}{Logical. If \code{TRUE} (default), entropy is normalised between 0 and 1. If \code{FALSE}, returns raw Shannon entropy.}
}
\value{
A numeric value representing the mean entropy of transmission trees across posterior samples.
}
\description{
Computes the mean entropy of transmission trees from \code{outbreaker2}, quantifying uncertainty in inferred infectors.
By default, entropy is normalised between 0 (complete certainty) and 1 (maximum uncertainty).
}
\details{
Entropy quantifies uncertainty in inferred infectors across posterior samples using the Shannon entropy formula:

\deqn{H(X) = -\sum p_i log(p_i)}

where \eqn{p_i} is the proportion of times each infector is inferred. If \code{normalise = TRUE}, entropy is scaled by its maximum possible value, \eqn{log(K)}, where \eqn{K} is the number of distinct inferred infectors:

\deqn{H^*(X) = \frac{H(X)}{log(K)}}

This normalisation ensures values range from 0 to 1:
\itemize{
\item \strong{0}: Complete certainty — the same infector is inferred across all samples.
\item \strong{1}: Maximum uncertainty — all infectors are equally likely.
}
}
\examples{

# High entropy
out <- data.frame(alpha_1 = sample(c("2", "3"), 100, replace = TRUE),
                  alpha_2 = sample(c("1", "3"), 100, replace = TRUE))
class(out) <- c("outbreaker_chains", class(out))
get_entropy(out)

# Low entropy
out <- data.frame(alpha_1 = sample(c("2", "3"), 100, replace = TRUE, prob = c(0.95, 0.05)),
                  alpha_2 = sample(c("1", "3"), 100, replace = TRUE, prob = c(0.95, 0.05)))
class(out) <- c("outbreaker_chains", class(out))
get_entropy(out)

}
