% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_degree.R
\name{f_fahrenheit}
\alias{f_fahrenheit}
\alias{f_celcius}
\alias{f_longitude}
\alias{f_latitude}
\alias{f_degree}
\alias{ff_degree}
\alias{ff_celcius}
\alias{ff_fahrenheit}
\alias{ff_longitude}
\alias{ff_latitude}
\title{Format Degrees (e.g., Temperature, Coordinates)}
\usage{
f_fahrenheit(
  x,
  digits = getOption("numformdigits"),
  prefix = NULL,
  suffix = TRUE,
  absolute.value = suffix,
  type = "scale",
  symbol = "&deg;",
  ...
)

f_celcius(
  x,
  digits = getOption("numformdigits"),
  prefix = NULL,
  suffix = TRUE,
  absolute.value = suffix,
  type = "scale",
  symbol = "&deg;",
  ...
)

f_longitude(
  x,
  digits = getOption("numformdigits"),
  prefix = NULL,
  suffix = TRUE,
  absolute.value = suffix,
  type = "scale",
  symbol = "&deg;",
  ...
)

f_latitude(
  x,
  digits = getOption("numformdigits"),
  prefix = NULL,
  suffix = TRUE,
  absolute.value = suffix,
  type = "scale",
  symbol = "&deg;",
  ...
)

f_degree(
  x,
  type = c("scale", "text", "scale", "title", "string"),
  digits = getOption("numformdigits"),
  prefix = NULL,
  suffix = TRUE,
  absolute.value = suffix,
  symbol = "&deg;",
  measure = c("fahrenheit", "celcius", "C", "F", "longitude", "latitude"),
  ...
)

ff_degree(...)

ff_celcius(...)

ff_fahrenheit(...)

ff_longitude(...)

ff_latitude(...)
}
\arguments{
\item{x}{A vector of values.}

\item{digits}{The number of digits to use.  Defaults to 1.  Can be set
globally via: \code{options(numformdigits = n)} where n is the number of
digits beyond the decimal point to include.}

\item{prefix}{A prefix to use before the parenthesis + units when
\code{type = 'title'}.}

\item{suffix}{logical.  If \code{TRUE} a suffix will be added corresponding
to the \code{measure}:
\describe{
  \item{celcius}{A capital C will be used}
  \item{fahrenheit}{A capital F will be used}
  \item{longitude}{Capital W and E will be used}
  \item{latitude}{Capital S and N will be used}
}}

\item{absolute.value}{logical.  If \code{TRUE} the absolute value of \code{x}
will be used.  This is useful for coordinates when E/W or N/S indicate direction.}

\item{type}{One of \code{c('scale', 'text', 'title', 'string')}:
\describe{
  \item{scale}{To be used for \pkg{ggplot2} scales (i.e., axis or legend)}
  \item{text}{To be used for \pkg{ggplot2} text (i.e., geom_text, annotate; note that \code{parse = TRUE} must be set}
  \item{title}{To be used for \pkg{ggplot2} titles (e.g., main title, axis title, legend title); ignores \code{x} values}
  \item{string}{To be used for plain text, especially table formatting and allows control over the degree symbol used}
}}

\item{symbol}{A symbol to use for degree when \code{type = 'string'}.}

\item{measure}{One of \code{c('fahrenheit', 'celcius', 'C', 'F', 'longitude',
'latitude')}.  There are functions by these names (e.g., \code{f_celcius}) but
not C or F.  These functions may be clearer than using \code{f_degree} and
then specifying \code{measure}.}

\item{\ldots}{ignored.}
}
\value{
Returns number string(s) with degree symbols.
}
\description{
Format numbers into degree format for strings, text, titles, and scales.
}
\note{
Note that this function differs a bit from other \code{f_} functions
in that in needs a \code{type}.  This is because other \code{f_} functions
return a plain text representation that is generalizable across usages (titles,
tables, axis, geom_text, etc).  This function has notation that requires
special parsing by various usages hence requiring the \code{type} argument.
}
\examples{
## used for ggplot2 axis.text & legend scale
f_celcius(37, type = 'scale')

## used for ggplot2 geom_text
f_celcius(37, type = 'text')

## used for ggplot2 titles
f_celcius(prefix = "My Title",  type = 'title')

## used for table and string formatting
f_celcius(37, type = 'string')
f_celcius(37, type = 'string', symbol = '\\\\textdegree')  # LaTeX

\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load(tidyverse, maps, viridis, mapproj)

states <- map_data("state")
arrests <- USArrests
names(arrests) <- tolower(names(arrests))
arrests$region <- tolower(rownames(USArrests))
choro <- merge(states, arrests, sort = FALSE, by = "region")
choro <- choro[order(choro$order), ]

ggplot(choro, aes(long, lat)) +
    geom_polygon(aes(group = group, fill = assault)) +
    coord_map("albers",  at0 = 45.5, lat1 = 29.5) +
    scale_y_continuous(labels = f_latitude) +
    scale_x_continuous(labels = f_longitude)

ggplot(choro, aes(long, lat)) +
    geom_polygon(aes(group = group, fill = assault)) +
    coord_map("albers",  at0 = 45.5, lat1 = 29.5) +
    scale_y_continuous(labels = ff_latitude(suffix = FALSE)) +
    scale_x_continuous(labels = ff_longitude(suffix = FALSE))


world <- map_data(map="world")

ggplot(world, aes(map_id = region, x = long, y = lat)) +
    geom_map(map = world, aes(map_id = region), fill = "grey40",
        colour = "grey70", size = 0.25) +
    scale_y_continuous(labels = f_latitude) +
    scale_x_continuous(labels = f_longitude)


data_frame(
    Event = c('freezing water', 'room temp', 'body temp', 'steak\'s done',
        'hamburger\'s done', 'boiling water'),
    F = c(32, 70, 98.6, 145, 160, 212)
) \%>\%
    mutate(
        C = (F - 32) * (5/9),
        Event = f_title(Event),
        Event = factor(Event, levels = unique(Event))
    ) \%>\%
    ggplot(aes(Event, F, fill = F)) +
        geom_col() +
        geom_text(aes(y = F + 4, label = f_fahrenheit(F, digits = 1, type = 'text')),
            parse = TRUE, color = 'grey60') +
        scale_y_continuous(
            labels = f_fahrenheit, limits = c(0, 220), expand = c(0, 0),
            sec.axis = sec_axis(trans = ~(. - 32) * (5/9), labels = f_celcius,
            name = f_celcius(prefix = 'Temperature ', type = 'title'))
        ) +
        scale_x_discrete(labels = ff_replace(pattern = ' ', replacement = '\n')) +
        scale_fill_viridis(option =  "magma", labels = f_fahrenheit, name = NULL) +
        theme_bw() +
        labs(
            y = f_fahrenheit(prefix = 'Temperature ', type = 'title'),
            title = f_fahrenheit(prefix = 'Temperature of Common Events ', type = 'title')
        ) +
        theme(
            axis.ticks.x = element_blank(),
            panel.border = element_rect(fill = NA, color = 'grey80'),
            panel.grid.minor.x = element_blank(),
            panel.grid.major.x = element_blank()
        )


data_frame(
    Event = c('freezing water', 'room temp', 'body temp', 'steak\'s done',
        'hamburger\'s done', 'boiling water', 'sun surface', 'lighting'),
    F = c(32, 70, 98.6, 145, 160, 212, 9941, 50000)
) \%>\%
    mutate(
        Event = f_title(Event),
        C = (F - 32) * (5/9)
    ) \%>\%
    mutate(
        F = f_degree(F, measure = 'F', type = 'string'),
        C = f_degree(C, measure = 'C', type = 'string', zero = '0.0')
    )  \%>\%
    data.frame(stringsAsFactors = FALSE, check.names = FALSE) \%>\%
    pander::pander(split.tables = Inf, justify = alignment(.))
}
}
