% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nullcat_commsim.R
\name{nullcat_commsim_seq}
\alias{nullcat_commsim_seq}
\title{Nullcat-based commsim (sequential / Markov chain)}
\usage{
nullcat_commsim_seq(
  method = nullcat_methods(),
  output = c("category", "index")
)
}
\arguments{
\item{method}{Character specifying which nullcat randomization algorithm
to use. See \code{\link[=nullcat]{nullcat()}} and \code{\link[=nullcat_methods]{nullcat_methods()}} for details.}

\item{output}{Character, passed to \code{nullcat(output = ...)}.
Typically \code{"category"} (default) or \code{"index"}.}
}
\value{
An object of class \code{"commsim"} suitable for use with
\code{vegan::nullmodel()} and \code{vegan::oecosimu()}.
}
\description{
Construct a \code{vegan::commsim()} object that uses \code{\link[=nullcat]{nullcat()}} as a
\emph{sequential} null model: successive simulated matrices form a
Markov chain. Internally, each simulation "step" advances the chain
by \code{thin} trades of the chosen \code{method} (e.g. \code{"curvecat"}), where
\code{thin} is supplied via `vegan::simulate.nullmodel()`` arguments.
This is analogous to how sequential swap / curveball null models
are used in \strong{vegan}, but extended to categorical data via
\code{\link[=nullcat]{nullcat()}}.
}
\section{Details}{


This model is \strong{sequential}: simulated matrices form a Markov chain. The current matrix is
updated in-place by repeated calls to the randomization model, and successive
matrices are obtained by advancing the chain.

In \code{vegan::simulate.nullmodel()}, the control arguments behave as:
\itemize{
\item \code{nsim}: number of matrices to \emph{store} from the chain.
\item \code{thin}: number of trades per step. Each "step" of the chain
applies \code{thin} trades of the chosen \code{method} to the current state
before possibly storing it.
\item \code{burnin}: number of initial steps to perform (each with \code{thin}
trades) before storing any matrices, i.e. the Markov chain
burn-in.
}

There is no \code{n_iter} argument here: mixing is controlled entirely by
\code{thin} (trades per step) and \code{burnin} (number of initial steps
discarded), in the same spirit as sequential swap / curveball models
in \strong{vegan}.
}

\examples{
\dontshow{if (requireNamespace("vegan", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
  library(vegan)

  x  <- matrix(sample(1:5, 50, replace = TRUE), 10, 5)
  cs <- nullcat_commsim_seq(method = "curvecat")

  nm <- nullmodel(x, cs)

  # control the chain with 'thin' and 'burnin'
  sims <- simulate(nm, nsim = 999, thin = 100, burnin = 1000)
}
\dontshow{\}) # examplesIf}
}
