% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsGenPareto.R
\name{Neutrosophic Generalized Pareto}
\alias{Neutrosophic Generalized Pareto}
\alias{dnsGenPareto}
\alias{pnsGenPareto}
\alias{qnsGenPareto}
\alias{rnsGenPareto}
\title{Neutrosophic Generalized Pareto Distribution}
\usage{
dnsGenPareto(x, shape, scale)

pnsGenPareto(q, shape, scale, lower.tail = TRUE)

qnsGenPareto(p, shape, scale)

rnsGenPareto(n, shape, scale)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{shape}{the shape parameter, which must be a positive interval.}

\item{scale}{the scale parameter, which must be a positive interval.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \leq x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{dnsGenPareto} gives the density function

 \code{pnsGenPareto} gives the distribution function

 \code{qnsGenPareto} gives the quantile function

 \code{rnsGenPareto} generates random variables from the neutrosophic generalized pareto distribution.
}
\description{
Density, distribution function, quantile function and random generation for
the neutrosophic generalized pareto distribution with parameters \code{shape} = \eqn{\alpha_N}
and \code{scale}=\eqn{\beta_N}.
}
\details{
The neutrosophic generalized pareto distribution with parameters \eqn{\alpha_N} and
\eqn{\beta_N} has density
\deqn{f_N(x)=\frac{1}{\beta_N}\left(1+\frac{\alpha_N x_N}{\beta_N} \right)^{-\frac{1}{\alpha_N}-1}}
for \eqn{x \ge 0}, \eqn{\alpha_N \in (\alpha_L, \alpha_U)}, the shape
parameter which must be a positive interval and
\eqn{\beta_N \in (\beta_L, \beta_U)}, the scale parameter which
must be a positive interval.
}
\examples{
data(remission)
dnsGenPareto(x = remission, shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))

pnsGenPareto(q = 20, shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))

# Calculate quantiles
qnsGenPareto(p = c(0.25, 0.5, 0.75), shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))

# Simulate 10 numbers
rnsGenPareto(n = 10, shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))
}
\references{
Eassa, N. I., Zaher, H. M., & El-Magd, N. A. A. (2023).
   Neutrosophic Generalized Pareto Distribution, \emph{Mathematics and Statistics},
   11(5), 827--833.
}
