% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npi_results_s3.R
\name{npi_flatten}
\alias{npi_flatten}
\title{S3 method to flatten an \code{npi_results} object}
\usage{
npi_flatten(df, cols, key)
}
\arguments{
\item{df}{A data frame containing the results of a call to
\code{\link{npi_search}}.}

\item{cols}{If non-NULL, only the named columns specified here will be be
flattened and returned along with \code{npi}.}

\item{key}{A quoted column name from \code{df} to use as a matching key. The
default value is \code{"npi"}.}
}
\value{
A data frame (tibble) with flattened list columns.
}
\description{
S3 method to flatten an \code{npi_results} object
}
\examples{
# Flatten all list columns
data(npis)
npi_flatten(npis)

# Only flatten specified columns
npi_flatten(npis, cols = c("basic", "identifiers"))
}
\concept{data wrangling functions}
