% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noisyr.R
\name{noisyr}
\alias{noisyr}
\title{Run the noisyR pipeline}
\usage{
noisyr(approach.for.similarity.calculation = c("counts", "transcript"), ...)
}
\arguments{
\item{approach.for.similarity.calculation}{which approach to use for the similarity calculation;
defaults to counts}

\item{...}{arguments to be passed on to noisyr_counts or noisyr_transcript; see their documentation
for more details and required arguments}
}
\value{
For the counts approach, the denoised expression matrix. For the transcript approach,
the numeric vector of noise thresholds per sample. For more details, see their respective documentation.
}
\description{
Calls one of noisyr_counts or noisyr_transcript, with the specified parameters.
See the individual function documentation for more details and required arguments:
\code{\link{noisyr_counts}}, \code{\link{noisyr_transcript}}
}
\examples{
noisyr(approach.for.similarity.calculation = "counts",
       expression.matrix = matrix(1:100, ncol = 5))
}
