% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/044_sym_hienc_ln.R
\name{sym_hienc_ln}
\alias{sym_hienc_ln}
\alias{sym_hienc_ln.default}
\alias{sym_hienc_ln.formula}
\title{Symmetric hierarchical/next-class label noise}
\usage{
\method{sym_hienc_ln}{default}(x, y, level, group, order = levels(y), sortid = TRUE, ...)

\method{sym_hienc_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{group}{a list of integer vectors with the indices of classes in each superclass.}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Symmetric hierarchical/next-class label noise} into a classification dataset.
}
\details{
\emph{Symmetric hierarchical/next-class label noise} randomly selects (\code{level}·100)\% of the samples
in the dataset with independence of their class. Then, the labels of these samples are replaced by 
the next class within the set of class labels related to them (given by the 
argument \code{group}). The indices in \code{group} are taken according to the order given by \code{order}. 
Note that if a class does not belong to any superclass, it may be mislabeled as any other class.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- sym_hienc_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1, 
                       group = list(c(1,2)), order = c("virginica", "setosa", "versicolor"))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- sym_hienc_ln(formula = Species ~ ., data = iris2D, level = 0.1,
                       group = list(c(1,2)), order = c("virginica", "setosa", "versicolor"))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
T. Kaneko, Y. Ushiku, and T. Harada. 
\strong{Label-noise robust generative adversarial networks}. 
In \emph{Proc. 2019 IEEE Conference on Computer Vision and Pattern Recognition}, 
pages 2462-2471, 2019.
\doi{10.1109/CVPR.2019.00257}.
}
\seealso{
\code{\link{sym_nexc_ln}}, \code{\link{sym_dia_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
