% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsZdir.nnct.ss}
\alias{funsZdir.nnct.ss}
\alias{Zdir.nnct.ss.ct}
\alias{Zdir.nnct.ss}
\title{Directional Segregation Test for Two Classes with Normal Approximation (for Sparse Sampling)}
\usage{
Zdir.nnct.ss.ct(
  ct,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Zdir.nnct.ss(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{The NNCT, used in \code{Zdir.nnct.ss.ct} only}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the confidence limits, default is \code{0.95}, 
for the difference in phat values in the NNCT}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Zdir.nnct.ss} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Zdir.nnct.ss} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Zdir.nnct.ss} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistic for the directional (i.e., one-sided) test of segregation based on
the NNCT}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative}
\item{conf.int}{Confidence interval for the difference in phat values in the NNCT
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{estimate}{Estimate of the parameter, i.e., the observed difference in phat values in the NNCT.}
\item{null.value}{Hypothesized null value for the difference in phat values in the NNCT
which is 0 for this function.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{Zdir.nnct.ss.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Zdir.nnct.ss} only}
}
\description{
Two functions: \code{Zdir.nnct.ss.ct} and \code{Zdir.nnct.ss}.

Both functions are objects of class \code{"htest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of independence in the \eqn{2 \times 2} NNCT which implies \eqn{Z_P=0}
or equivalently \eqn{N_{11}/n_1=N_{21}/n_2}.
\eqn{Z_P=(N_{11}/n_1-N_{21}/n_2)\sqrt{n_1 n_2 n/(C_1 C_2)}} 
where \eqn{N_{ij}} is the cell count in entry \eqn{i,j}, \eqn{n_i} is the sum of row \eqn{i} (i.e., size of class \eqn{i}),
\eqn{c_j} is the sum of column \eqn{j} in the \eqn{2 \times 2} NNCT;
\eqn{N_{11}/n_1} and \eqn{N_{21}/n_2} are also referred to as the phat estimates in row-wise binomial framework
for \eqn{2 \times 2} NNCT (see \insertCite{ceyhan:jnps-NNCT-2010;textual}{nnspat}).

That is, each performs directional (i.e., one-sided) tests based on the \eqn{2 \times 2} NNCT and is appropriate
(i.e., have the appropriate asymptotic sampling distribution)
when that data is obtained by sparse sampling.
(See \insertCite{ceyhan:jnps-NNCT-2010;textual}{nnspat} for more detail).

Each test is based on the normal approximation of \eqn{Z_P} which is the directional \eqn{Z}-tests for the chi-squared
tests of independence for the contingency tables \insertCite{bickel:1977}{nnspat}.

Each function yields the test statistic, \eqn{p}-value for the
corresponding alternative, the confidence interval, sample estimate (i.e., observed value) and
null (i.e., expected) value for the difference in the phat values (which is 0 for this test) in an NNCT, 
and method and name of the data set used.

The null hypothesis is that \eqn{E[Z_P] = 0} or equivalently \eqn{N_{11}/n_1 = N_{21}/n_2}.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

Zdir.nnct.ss(Y,cls)
Zdir.nnct.ss.ct(ct)
Zdir.nnct.ss(Y,cls,alt="g")

Zdir.nnct.ss(Y,cls,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

Zdir.nnct.ss(Y,fcls)
Zdir.nnct.ss.ct(ct)

#############
ct<-matrix(1:4,ncol=2)
Zdir.nnct.ss.ct(ct) #gives an error message if ct<-matrix(1:9,ncol=3)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Zdir.nnct.ct}}, \code{\link{Zdir.nnct}}, \code{\link{Pseg.ss.ct}} and \code{\link{Pseg.ss}}
}
\author{
Elvan Ceyhan
}
