% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Csn.R
\name{Csn}
\alias{Csn}
\title{Csn}
\usage{
Csn(n, q, eps)
}
\arguments{
\item{n}{The number of Taylor iterations. Accuracy as well as computation
time increases as \eqn{n} increases}

\item{q}{a real number in \eqn{(2,\infty)}. Accuracy as well as computation
time increases as \eqn{q} gets closer to \eqn{2} increases}

\item{eps}{a real number in \eqn{(0,\infty)}. ccuracy as well as computation
time increases as \eqn{\varepsilon} gets closer to \eqn{0} increases

\emph{Note: } In practice for most desktop uses
\eqn{q < 2.05} and \eqn{\varepsilon< 0.05} tends to cause problems in
"too long a vector", atleaast as tested on my computer.}
}
\value{
A neural network that approximates \eqn{\cos} under instantiation
with ReLU activation. See also \code{\link{Sne}}.
}
\description{
The function that returns \eqn{\mathsf{Csn}}.
}
\examples{
Csn(2, 2.5, 0.5) # this may take some time

Csn(2, 2.5, 0.5) |> inst(ReLU, 1.50)

}
\references{
Definition 2.29 in Rafi S., Padgett, J.L., Nakarmi, U. (2024) Towards an Algebraic Framework For
Approximating Functions Using Neural Network Polynomials
\url{https://arxiv.org/abs/2402.01058}
}
