% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recon_vcov.R
\name{recon_vcov}
\alias{recon_vcov}
\title{Reconstruct likelihood covariance matrix}
\usage{
recon_vcov(
  post,
  prior.prec = 1e-04,
  prior.vcov = diag(1/prior.prec, dim(post)[1]),
  X = NULL,
  verbose = FALSE
)
}
\arguments{
\item{post}{Posterior covariance matrix.}

\item{prior.prec}{Prior precision. Defaults to .0001 which is a common flat
prior for NMA. Not used if \code{prior.vcov} is specified.}

\item{prior.vcov}{Prior covariance matrix. Defaults to a diagonal matrix of
the same size as post, with elements \code{1/prior.prec}.}

\item{X}{Contrast design matrix. If omitted a complete network is assumed.}

\item{verbose}{Print intermediate matrices? Defaults to \code{FALSE}.}
}
\value{
A matrix; the reconstructed likelihood covariance matrix. If NNLS is
  used, the residual sum-of-squares and Kullback-Leibler divergence
  diagnostics (as printed to the console) are returned as additional
  attributes \code{rss.total}, \code{rss.fixed}, \code{rss.free},
  \code{kl.divergence}.
}
\description{
Reconstruct the contrast-level likelihood covariance matrix from prior and
posterior covariance matrices. The resulting likelihood covariance matrix can
then be used to perform a contrast-level threshold analysis with the function
\code{nma_thresh}.
}
\details{
Full details of the calculation are given by Phillippo \emph{et al.}
  (2018). Briefly, the aim is to recover the contrast-level likelihood
  covariance matrix \eqn{V} that would have led to the posterior covariance
  matrix \eqn{\Sigma} being obtained from a fixed effects NMA, with design
  matrix \eqn{X} and prior covariance matrix \eqn{\Sigma_d} for a normal
  prior on the basic treatment parameters. This is possible in this case via
  the equation (resulting from conjugacy):

  \deqn{\Sigma^{-1} = X^TV^{-1}X + \Sigma_d^{-1}.}

  When the treatment network is complete (i.e. fully connected), this
  equation may be rearranged exactly.

  When the treatment network is incomplete (i.e. not all treatments are
  directly compared), this equation may be solved through the use of
  non-negative least squares (NNLS).

  When NNLS is used, some additional diagnostics are printed (and returned as
  attributes). Firstly, the residual sum-of-squares (RSS) from the NNLS fit.
  The RSS is further split into \emph{fixed} RSS, from structural zeros in
  the reconstructed posterior according to the design matrix (and hence not
  fitted) that are non-zero in the true posterior, and \emph{fitted} RSS,
  from the other fitted elements. Secondly, the Kullback-Leibler divergence
  of the reconstructed posterior from the true posterior. Interpreting the KL
  divergence as a log Bayes factor, values less than 1 indicate negligible
  differences between the reconstructed posterior from the true posterior,
  whilst values greater than 3 indicate considerable differences.
}
\examples{
# Please see the vignette "Examples" for worked examples including use of
# this function, including more information on the brief code below.

vignette("Examples", package = "nmathresh")

### Contrast level thresholds for Thrombolytic treatments NMA
K <- 6   # Number of treatments

# Contrast design matrix is
X <- matrix(ncol = K-1, byrow = TRUE,
            c(1, 0, 0, 0, 0,
              0, 1, 0, 0, 0,
              0, 0, 1, 0, 0,
              0, 0, 0, 1, 0,
              0, -1, 1, 0, 0,
              0, -1, 0, 1, 0,
              0, -1, 0, 0, 1))

# Reconstruct hypothetical likelihood covariance matrix using NNLS
lik.cov <- recon_vcov(Thrombo.post.cov, prior.prec = .0001, X = X)

}
\seealso{
\code{\link{nma_thresh}}.
}
