% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlshrink_cov.R
\name{nlshrink_cov}
\alias{nlshrink_cov}
\title{Non-linear shrinkage estimator of population covariance matrix.}
\usage{
nlshrink_cov(X, k = 0, method = "nlminb", control = list())
}
\arguments{
\item{X}{A data matrix.}

\item{k}{(Optional) Non-negative integer less than \code{ncol(X)}. If \code{k
== 0} (default), \code{X} is assumed to contain 1 class, which will be
centered. If \code{k >= 1}, \code{X} is assumed to contain \code{k}
classes, each of which has already been centered.}

\item{method}{(Optional) The optimization routine called in
\code{\link{tau_estimate}}. Choices are \code{nlminb} (default) and
\code{nloptr}.}

\item{control}{(Optional) A list of control parameters. Must correspond to
the selected optimization method. See \code{\link[stats]{nlminb}},
\code{\link[nloptr]{nloptr}} for details.}
}
\value{
A numeric positive semi-definite matrix of dimension \code{ncol(X)}.
}
\description{
\code{nlshrink_cov} calls \code{\link{tau_estimate}} to estimate
  the population eigenvalues. Note that the eigenvalues of the estimated
  population covariance matrix are not the same as the non-linear shrinkage
  estimates of the population eigenvalues. Theoretical and implementation
  details in references.
}
\examples{
# generate matrix of uniform random variates
X <- matrix(sapply(1:20, function(b) runif(50, max=b)), nrow = 50, ncol = 20)
Sigma <- diag((1:20)^2/12) # true population covariance matrix
nlshrink_X <- nlshrink_cov(X, k=0) # compute non-linear shrinkage estimate
linshrink_X <- linshrink_cov(X, k=0) # compute linear shrinkage estimate
S <- cov(X) # sample covariance matrix

# compare accuracy of estimators (sum of squared elementwise Euclidean distance)
sum((S-Sigma)^2)
sum((nlshrink_X - Sigma)^2)
sum((linshrink_X - Sigma)^2)

}
\references{
\itemize{ \item Ledoit, O. and Wolf, M. (2015). Spectrum
  estimation: a unified framework for covariance matrix estimation and PCA in
  large dimensions. Journal of Multivariate Analysis, 139(2) \item Ledoit, O.
  and Wolf, M. (2016). Numerical Implementation of the QuEST function.
  arXiv:1601.05870 [stat.CO] }
}

