% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_modelfit.R
\name{run_npd_2cmpt_iv}
\alias{run_npd_2cmpt_iv}
\title{Run and evaluate a two-compartment IV model}
\usage{
run_npd_2cmpt_iv(
  dat,
  est.method = "nls",
  input.cl = exp(1),
  input.vc2cmpt = exp(1),
  input.vp2cmpt = exp(1),
  input.q2cmpt = exp(1),
  input.add = 1
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in standard
nlmixr2 format.}

\item{est.method}{Estimation method used in nlmixr2. Defaults to "nls".}

\item{input.cl}{Initial estimate for clearance (CL). Defaults to exp(1),
corresponding to a log-scale value of 1.}

\item{input.vc2cmpt}{Initial estimate for central compartment volume (Vc).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.vp2cmpt}{Initial estimate for peripheral compartment volume (Vp).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.q2cmpt}{Initial estimate for intercompartmental clearance (Q).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.add}{Additive error term. Defaults to 1.}
}
\value{
A list containing parameter estimates and prediction error metrics.
}
\description{
Fits a two-compartment intravenous pharmacokinetic model using a naive pooled
data approach and evaluates model performance based on prediction error
metrics.
}
\details{
Rows with \code{EVID == 2} are excluded prior to model fitting. The model is fitted
using \code{Fit_2cmpt_iv}, and prediction-based metrics are calculated to assess
performance.
}
\examples{
\donttest{
run_npd_2cmpt_iv(dat = Bolus_2CPT,
                           input.cl = 4,
                           input.vc2cmpt = 35,
                           input.vp2cmpt = 35,
                           input.q2cmpt = 4)
}

}
\seealso{
\code{\link{Fit_2cmpt_iv}}
}
\author{
Zhonghui Huang
}
