% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPPKinits.R
\name{getPPKinits}
\alias{getPPKinits}
\title{Automated pipeline for generating initial estimates in population PK models}
\usage{
getPPKinits(dat, control = initsControl(), verbose = TRUE)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic records in standard nlmixr2
format, including ID, TIME, EVID, and DV.}

\item{control}{A list created by \code{initsControl()} specifying configuration for
pooling, non-compartmental analysis, steady-state detection, fallback rules,
statistical model components, and parameter selection metrics.}

\item{verbose}{Logical (default = TRUE); when TRUE, displays key progress
messages and stepwise updates during the initialization process. When FALSE,
the function runs quietly without printing intermediate information.}
}
\value{
An object of class \code{getPPKinits} containing recommended initial
parameter estimates, intermediate results, and computation diagnostics.
}
\description{
Provides a unified and fully automated workflow to generate initial
pharmacokinetic and residual variability parameters for population PK models
using concentration–time data from bolus, infusion, or oral administration.
}
\details{
The pipeline integrates four model-informed analytical components applied to
raw or pooled concentration–time profiles:
\enumerate{
\item Adaptive single-point methods
\item Naive pooled graphic methods
\item Naive pooled non-compartmental analysis (NCA) with optional Wagner–Nelson Ka calculation for oral dosing
\item Parameter sweeping across one-, two-, three-compartment and Michaelis–Menten models
}

In addition to structural PK parameters, the framework also initializes
statistical model components:
\itemize{
\item Inter-individual variability (IIV): pragmatic fixed \eqn{\omega^2}
values are assigned to random effects.
\item Residual unexplained variability (RUV): estimated either using a
data-driven method based on trimmed residual summaries or a
fixed-fraction approach consistent with NONMEM User Guide recommendations.
\item Model applicability: the automated and model-informed strategy
generates robust initial values suitable for both linear and nonlinear
mixed-effects pharmacokinetic models.
}
}
\examples{
\donttest{
## Bolus example
getPPKinits(Bolus_1CPT,verbose = TRUE)
## Oral example (run quietly)
getPPKinits(Oral_1CPT,verbose = FALSE)
}

}
\seealso{
\code{\link{initsControl}}, \code{\link{run_single_point}},
\code{\link{run_graphcal}}, \code{\link{run_pooled_nca}},
\code{\link{sim_sens_1cmpt_mm}}, \code{\link{sim_sens_2cmpt}},
\code{\link{sim_sens_3cmpt}}, \code{\link{metrics.}}
}
\author{
Zhonghui Huang
}
