% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aco.cores.R
\name{createAnts}
\alias{createAnts}
\title{Create ant population for ACO}
\usage{
createAnts(
  search.space = "ivbase",
  nants = 15,
  init = FALSE,
  nodeslst = NULL,
  custom_config = NULL,
  fixed = NULL
)
}
\arguments{
\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{nants}{Integer. Number of ants (candidate solutions) generated
at each iteration. Defaults to 15.}

\item{init}{Logical. If TRUE, a subset of ants is initialized as fixed base
models and the remaining ants are generated by probabilistic sampling.
If FALSE, all ants are generated by probabilistic sampling.}

\item{nodeslst}{Data frame containing pheromone information used for
probabilistic sampling. It must include node identifiers and associated
sampling probabilities. This argument is required whenever random ants
are generated.}

\item{custom_config}{Optional named list defining a custom parameter structure.
If provided, the parameter names are taken from the names of this list.
If NULL, a default parameter structure is used based on the selected
search space.}

\item{fixed}{Optional list specifying fixed ants for initialization.
The list may contain the following elements:
\itemize{
\item n: number of fixed ants.
\item mat: optional matrix specifying fixed ant encodings, with
parameters in rows and ants in columns.
}}
}
\value{
A numeric matrix in which rows correspond to model parameters and columns
correspond to individual ants. Column names identify ants sequentially.

Parameter values are encoded as integers. Binary indicators represent
exclusion or inclusion of model components, categorical values represent
multi-level structural choices, and the value -1 indicates that a parameter
is not applicable for the given model structure.
}
\description{
Generate a population of ants (candidate models) for use in an
ant colony optimization algorithm for pharmacometric model search.
}
\details{
Each ant is represented as a column vector encoding discrete structural
model decisions, including the number of compartments, inclusion of random
effects, Michaelis--Menten elimination, correlation structures, and residual
error models. The set of parameters included in the encoding depends on the
selected search space.

Ants are generated using a combination of fixed initialization and
pheromone-guided probabilistic sampling. When fixed initialization is
enabled, a subset of ants corresponds to predefined base models, such as
one- to three-compartment structures with different residual error models.
The remaining ants are sampled according to probability distributions
derived from pheromone weights stored in the node list.

Structural dependencies between parameters are enforced during generation.
For example, parameters associated with peripheral compartments are only
active when the number of compartments is sufficient, and parameters related
to Michaelis--Menten elimination are only sampled when the corresponding
mechanism is selected. Parameters that are not applicable for a given
structure are encoded with a value of -1.
}
\examples{
# Example 1: Use defaults (6 fixed base models)
nodes <- initNodeList(search.space = "ivbase", phi0 = 1)
createAnts(
  search.space = "ivbase",
  nants = 15,
  init = TRUE,
  nodeslst = nodes
)

# Example 2: Custom number of fixed ants
createAnts(
  search.space = "ivbase",
  nants = 20,
  init = TRUE,
  nodeslst = nodes,
  fixed = list(n = 10)  # 10 fixed, mat = NULL (auto-generate)
)

# Example 3: Custom fixed models
my_models <- matrix(
  c(1, -1, 0, -1, -1, -1, -1, 0, 0, 1,
    2, -1, 1,  0, -1,  0, -1, 0, 0, 2,
    3, -1, 1,  1,  0,  1,  0, 1, 1, 3),
  nrow = 10, ncol = 3
)
rownames(my_models) <- c("no.cmpt", "eta.km", "eta.vc", "eta.vp",
                         "eta.vp2", "eta.q", "eta.q2", "mm", "mcorr", "rv")

createAnts(
  search.space = "ivbase",
  nants = 10,
  init = TRUE,
  nodeslst = nodes,
  fixed = list(n = 3, mat = my_models)
)
}
\seealso{
\code{\link{initNodeList}}, \code{\link{aco.operator}}
}
\author{
Zhonghui Huang
}
