% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelGen.R
\name{add_covariate}
\alias{add_covariate}
\title{Add a covariate effect to a parameter model}
\usage{
add_covariate(
  param_name,
  covariate_var,
  param_model,
  beta_value = NULL,
  existing_betas = c(),
  use_fix = TRUE
)
}
\arguments{
\item{param_name}{Character. Target parameter name (e.g., "cl", "vc").}

\item{covariate_var}{Character. Covariate variable name (e.g., "WT", "BMI").}

\item{param_model}{Character. Current parameter model expression (e.g., "cl = exp(tcl)").}

\item{beta_value}{Numeric. Optional fixed beta value. If NULL, uses built-in rules.}

\item{existing_betas}{Character vector. Existing beta definitions to append to.}

\item{use_fix}{Logical. Use \code{fix()} for beta values? Default TRUE.}
}
\value{
List with two elements:
\itemize{
\item betas - Updated character vector of beta definitions
\item mod - Modified model expression with covariate term
}
}
\description{
Automates the creation of covariate effects in pharmacometric models by
generating appropriate beta coefficients and modifying model expressions.
Supports both standard allometric scaling rules and custom covariate effects.
}
\details{
Automatic beta selection rules:
\itemize{
\item Standard covariates ("wt"/"ffm"/"bmi"/"bsa"):
\itemize{
\item 0.75 for clearance parameters (cl/q/q2)
\item 1.0 for volume parameters (vc/vp/vp2)
}
\item Other covariates: Default beta = -0.1 with message
}
}
\examples{
# Add weight effect to clearance
 add_covariate( "cl", "WT", "cl = exp(tcl)")

# Custom beta value for BMI effect
add_covariate(
  "vc", "BMI", "vc = exp(tvc)",
  beta_value = -0.2, use_fix = FALSE
)
}
\author{
Zhonghui Huang
}
