% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik1.R
\name{logLik1}
\alias{logLik1}
\title{Calculates contribution of one subject to the log-likelihood}
\usage{
logLik1(modfit, dt1, dtInit)
}
\arguments{
\item{modfit}{an object representing a model fitted to data using maximum likelihood estimation.}

\item{dt1}{a data frame with data for one subject, for whom the log-likelihood function is to be evaluated.}

\item{dtInit}{an optional auxiliary data frame.}
}
\value{
Numeric scalar value representing the contribution of a given subject to the overall log-likelihood returned by \code{\link[nlme:logLik.lme]{logLik}}.
}
\description{
This function is generic; method functions can be written to handle specific classes of objects.
}
\details{
Calculates contribution of one subject to the log-likelihood

This function is generic; method functions can be written to handle specific classes of objects.
}
\examples{
  library(nlme)
  logLik(fm1 <- lme(distance ~ age, data = Orthodont)) # random is ~ age
  dt1 <- subset(Orthodont, Subject == "M01")
  logLik1(fm1, dt1)
}
\references{
Galecki, A., & Burzykowski, T. (2013). *Linear Mixed-Effects Models: A Step-by-Step Approach*. Springer.
}
\author{
Andrzej Galecki and Tomasz Burzykowski
}
