% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmeU-package.R
\docType{data}
\name{armd0}
\alias{armd0}
\title{armd0 Data (1107 x 8)}
\format{
A data frame with 1107 rows and 8 columns:
\describe{
  \item{subject}{A factor with 240 levels: \code{1}, \code{2}, \code{3}, \code{4}, \code{5}, ...}
  \item{treat.f}{A factor with 2 levels: \code{Placebo}, \code{Active}}
  \item{visual0}{An integer vector with values from 20 to 85}
  \item{miss.pat}{A factor with 9 levels: \code{----}, \code{---X}, \code{--X-}, \code{--XX}, \code{-XX-}, ...}
  \item{time.f}{A factor with 5 levels: \code{Baseline}, \code{4wks}, \code{12wks}, \code{24wks}, \code{52wks}}
  \item{time}{A numeric vector with values from 0 to 52}
  \item{visual}{An integer vector with values from 3 to 85}
  \item{tp}{A numeric vector with values from 0 to 4}
}
}
\source{
Pharmacological Therapy for Macular Degeneration Study Group (1997).
  Interferon alpha-IIA is ineffective for patients with choroidal neovascularization secondary to age-related macular degeneration.
  Results of a prospective randomized placebo-controlled clinical trial. Archives of Ophthalmology, 115, 865-872.
}
\usage{
armd0
}
\description{
Data from Age-Related Macular Degeneration (ARMD) clinical trial
}
\details{
The ARMD data arise from a randomized multi-center clinical trial comparing an experimental treatment (interferon-alpha)
versus placebo for patients diagnosed with ARMD.
}
\examples{
data(armd0, package = "nlmeU")
summary(armd0)
}
\seealso{
\code{\link{armd}}, \code{\link{armd.wide}}
}
\keyword{datasets}
