% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMVC.R
\name{IMVC}
\alias{IMVC}
\title{Integrated Mean Variance Correlation}
\usage{
IMVC(y, x, K, NN = 3, type)
}
\arguments{
\item{y}{is a numeric vector}

\item{x}{is a numeric vector}

\item{K}{is the number of quantile levels}

\item{NN}{is the number of B spline basis, default is 3}

\item{type}{is an indicator for measuring linear or nonlinear correlation, "linear" represents linear correlation and "nonlinear" represents linear or nonlinear correlation using B splines}
}
\value{
The value of the corresponding sample statistic
}
\description{
This function is used to calculate the integrated mean variance correlation between two vectors
}
\examples{
n=200
x=rnorm(n)
y=x^2+rt(n,2)

IMVC(y,x,K=10,type="nonlinear")
}
