% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kd.R
\name{kd}
\alias{kd}
\alias{dkd}
\alias{pkd}
\alias{qkd}
\alias{rkd}
\title{Kumaraswamy Distribution}
\usage{
dkd(x, lambda, alpha, log = FALSE)

pkd(q, lambda, alpha, lower.tail = TRUE, log.p = FALSE)

qkd(p, lambda, alpha, lower.tail = TRUE)

rkd(n, lambda, alpha)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{alpha, lambda}{are non-negative shape parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dkd} gives the density, \code{pkd} gives the distribution
function, \code{qkd} gives the quantile function and \code{rkd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
Kumaraswamy distribution with \code{shape} parameters.
}
\details{
Kumaraswamy distribution with non-negative shape
parameters \eqn{\alpha} and \eqn{\lambda} has density
\deqn{f\left( x\right) =\alpha \lambda x^{\lambda -1}\left( 1-x^{\lambda }
\right)^{\alpha -1},}
where
\deqn{0<x<1,~~\alpha ,\lambda >0.}
}
\examples{
library("new.dist")
dkd(0.1,lambda=2,alpha=3)
pkd(0.5,lambda=2,alpha=3)
qkd(.8,lambda=2,alpha=3)
rkd(10,lambda=2,alpha=3)
}
\references{
Kohansal, A. ve Bakouch, H. S., 2021,
\emph{Estimation procedures for Kumaraswamy distribution parameters under
adaptive type-II hybrid progressive censoring}, Communications in
Statistics-Simulation and Computation, 50 (12), 4059-4078.
}
