% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/SparseBrainVector.R, R/BrainVector.R
\docType{methods}
\name{eachVolume}
\alias{eachVolume}
\alias{eachVolume,BrainBucket,function,logical,ANY-method}
\alias{eachVolume,BrainBucket,function,missing,missing-method}
\alias{eachVolume,BrainVector,function,logical,ANY-method}
\alias{eachVolume,BrainVector,function,missing,BrainVolume-method}
\alias{eachVolume,BrainVector,function,missing,missing-method}
\alias{eachVolume,SparseBrainVector,function,logical,missing-method}
\alias{eachVolume,SparseBrainVector,function,missing,LogicalBrainVolume-method}
\alias{eachVolume,SparseBrainVector,function,missing,missing-method}
\title{Generic function to apply a function to each volume of a four-dimensional image}
\usage{
eachVolume(x, FUN, withIndex, mask, ...)

\S4method{eachVolume}{SparseBrainVector,`function`,logical,missing}(x, FUN,
  withIndex = FALSE, mask, ...)

\S4method{eachVolume}{SparseBrainVector,`function`,missing,missing}(x, FUN,
  withIndex, mask, ...)


  \S4method{eachVolume}{SparseBrainVector,`function`,missing,LogicalBrainVolume}(x,
  FUN, withIndex, mask, ...)

\S4method{eachVolume}{BrainVector,`function`,missing,missing}(x, FUN, withIndex,
  mask, ...)

\S4method{eachVolume}{BrainVector,`function`,missing,BrainVolume}(x, FUN,
  withIndex, mask, ...)

\S4method{eachVolume}{BrainVector,`function`,missing,missing}(x, FUN, withIndex,
  mask, ...)

\S4method{eachVolume}{BrainBucket,`function`,missing,missing}(x, FUN, withIndex,
  mask, ...)

\S4method{eachVolume}{BrainBucket,`function`,logical,ANY}(x, FUN, withIndex,
  mask, ...)

\S4method{eachVolume}{BrainVector,`function`,logical,ANY}(x, FUN, withIndex,
  mask, ...)
}
\arguments{
\item{x}{four-dimensional image, e.g. of class \code{BrainVector}}

\item{FUN}{a \code{function} taking one or two arguments (depending on the value of \code{withIndex})}

\item{withIndex}{whether the index of the volume supplied as the second argument to the function}

\item{mask}{an image mask indicating subset of volume elements to apply function over}

\item{...}{additional arguments}
}
\value{
a \code{list} of results of apply \code{FUN} to each volume.
}
\description{
Generic function to apply a function to each volume of a four-dimensional image
}
\examples{
bvec <- BrainVector(array(rnorm(24*24*24*24), c(24,24,24,24)), BrainSpace(c(24,24,24,24), c(1,1,1)))
res <- eachVolume(bvec, mean)

res <- eachVolume(bvec, function(x,i) median(x), withIndex=TRUE)
}

