% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neurovec.R
\name{vec_from_vols}
\alias{vec_from_vols}
\title{Create NeuroVec from list of NeuroVol objects}
\usage{
vec_from_vols(vols, mask = NULL)
}
\arguments{
\item{vols}{A list of \code{\linkS4class{NeuroVol}} objects. All volumes must have
identical spatial dimensions.}

\item{mask}{An optional logical array or \code{\linkS4class{LogicalNeuroVol}} object
defining the subset of voxels to include. If provided, a SparseNeuroVec will be created.}
}
\value{
A \code{\linkS4class{NeuroVec}} object (either DenseNeuroVec or SparseNeuroVec
  depending on whether a mask is provided).
}
\description{
Factory function to create a NeuroVec object from a list of NeuroVol objects.
This is a convenience wrapper around the NeuroVec constructor that combines
multiple 3D volumes into a single 4D NeuroVec.
}
\examples{
# Create a simple NeuroVec from list of volumes
spc <- NeuroSpace(c(10, 10, 10))
vol1 <- NeuroVol(rnorm(10*10*10), spc)
vol2 <- NeuroVol(rnorm(10*10*10), spc)
vec <- vec_from_vols(list(vol1, vol2))
print(dim(vec))  # Should be c(10, 10, 10, 2)

}
\seealso{
\code{\link{NeuroVec}}, \code{\link{NeuroVol}}
}
