% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgb_nuisance.R
\name{prepare_confounds}
\alias{prepare_confounds}
\title{Prepare weighted nuisance projectors for each run}
\usage{
prepare_confounds(
  confounds,
  time_weights = NULL,
  run_lengths,
  include_intercept = TRUE,
  center_cols = TRUE,
  scale_cols = FALSE
)
}
\arguments{
\item{confounds}{List of matrices (\eqn{T_k \times p_k}), or a single matrix
reused for all runs. Each row corresponds to a time point.}

\item{time_weights}{Optional list of numeric vectors (length \eqn{T_k}) or a
single vector reused for every run. If \code{NULL}, unit weights are used.}

\item{run_lengths}{Integer vector with the number of time points per run.
Required when any run has both \code{confounds=NULL} and \code{time_weights=NULL}.}

\item{include_intercept}{Logical; prepend a column of ones before QR (default TRUE).}

\item{center_cols}{Logical; center each confound column before weighting (default TRUE).}

\item{scale_cols}{Logical; scale columns to unit variance before weighting (default FALSE).}
}
\value{
A list with elements \code{Q_list} (list of matrices) and
  \code{sqrtw_list} (list of numeric vectors). Each entry has the same length
  as \code{run_lengths}.
}
\description{
Converts per-run confound matrices and time weights into orthonormal projectors
that can be consumed directly by the C++ graph builder. Each run produces
\eqn{Q_k} (columns spanning the weighted confound space) and \eqn{\sqrt{w_k}}
(per-time-point square-root weights). Supplying a \code{NULL} confound matrix
yields a zero-column projector, enabling pure time-weighting without
regression.
}
