% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_citation.R
\name{neon_citation}
\alias{neon_citation}
\title{Generate the appropriate citation for your data}
\usage{
neon_citation(product = NULL, download_date = Sys.Date(), dir = neon_dir())
}
\arguments{
\item{product}{A NEON \code{productCode} or list of product codes, see examples.}

\item{download_date}{Date of download to be included in citation.
default is today's date, see details.}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \code{\link[tools:userdir]{tools::R_user_dir()}}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}
}
\value{
returns a \link[utils:bibentry]{utils::bibentry} object, which can be used as text
or formatted for bibtex.
}
\description{
Generate the appropriate citation for your data
}
\details{
Note that the \code{neon_download()} does not record download date for each file.
Citing a single product download date is after all rather meaningless, as
parts of a products may not have all been downloaded on different dates.
Indeed, \code{neon_download()} is designed in precisely this way, to allow easy
updating of downloads without re-downloading older data.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{ # may be slow
neon_citation("DP1.10003.001")

## or the citation for all products in store:
neon_citation()

## as bibtex
format(neon_citation("DP1.10003.001"), "bibtex")
}
\dontshow{\}) # examplesIf}
}
\references{
https://www.neonscience.org/data-samples/data-policies-citation
}
