% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_neon_flux.R
\name{compute_neon_flux}
\alias{compute_neon_flux}
\title{Compute NEON fluxes at a site}
\usage{
compute_neon_flux(input_site_env, input_site_megapit)
}
\arguments{
\item{input_site_env}{Required. Input list of environmental data.  Usually given from acquire_neon_data}

\item{input_site_megapit}{Required. Input list of environmental soil data.  Usually given from acquire_neon_data}
}
\value{
Data frame of fluxes and gradient from the timeperiod
}
\description{
Given a site filename (from acquire_neon_data), process and compute fluxes.
This file takes a saved data file from acquire:
1) Takes the needed components (QF and measurement flags) for soil water, temperature, co2, binding them together in a tidy data frame
2) Interpolates across the measurements
3) Merges air pressure data into this data frame
4) Does a final QF check so we should have only timeperiods where all measurements exist
5) Adds in the megapit data so we have bulk density, porosity measurements at the interpolated depth.
6) Saves the data
}
\examples{
\donttest{
 # First acquire the NEON data at a given NEON site
out_env_data <- acquire_neon_data("SJER","2020-05")

# Then process and compute the fluxes:
 out_flux <- compute_neon_flux(input_site_env = sjer_env_data_2022_06,
 input_site_megapit = sjer_megapit_data_2022_06)
}
}
\author{
John Zobitz \email{zobitz@augsburg.edu}
based on code developed by Edward Ayres \email{eayres@battelleecology.org}
}
