% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_below.R
\name{impute_below_all}
\alias{impute_below_all}
\title{Impute data with values shifted 10 percent below range.}
\usage{
impute_below_all(.tbl, prop_below = 0.1, jitter = 0.05, ...)
}
\arguments{
\item{.tbl}{a data.frame}

\item{prop_below}{the degree to shift the values. default is}

\item{jitter}{the amount of jitter to add. default is 0.05}

\item{...}{additional arguments}
}
\value{
an dataset with values imputed
}
\description{
It can be useful in exploratory graphics to impute data outside the range of
the data. \code{impute_below_all} imputes all variables with missings to have
values 10\\% below the range for numeric values, and for character or factor
values adds a new string or label.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
}
\examples{

# you can impute data like so:
airquality \%>\%
  impute_below_all()

# However, this does not show you WHERE the missing values are.
# to keep track of them, you want to use `bind_shadow()` first.

airquality \%>\%
  bind_shadow() \%>\%
  impute_below_all()

# This identifies where the missing values are located, which means you
# can do things like this:

\dontrun{
library(ggplot2)
airquality \%>\%
  bind_shadow() \%>\%
  impute_below_all() \%>\%
  # identify where there are missings across rows.
  add_label_shadow() \%>\%
  ggplot(aes(x = Ozone,
             y = Solar.R,
             colour = any_missing)) +
  geom_point()
# Note that this ^^ is a long version of `geom_miss_point()`.
}

}
