% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmvss.R
\name{pmvss}
\alias{pmvss}
\title{Multivariate Subgaussian Stable Distribution}
\usage{
pmvss(
  lower = rep(-Inf, d),
  upper = rep(Inf, d),
  alpha = 1,
  Q = NULL,
  delta = rep(0, d),
  maxpts.pmvnorm = 25000,
  abseps.pmvnorm = 0.001,
  outermost.int = c("stats::integrate", "cubature::adaptIntegrate")[1],
  subdivisions.si = 100L,
  rel.tol.si = .Machine$double.eps^0.25,
  abs.tol.si = rel.tol.si,
  stop.on.error.si = TRUE,
  tol.ai = 1e-05,
  fDim.ai = 1,
  maxEval.ai = 0,
  absError.ai = 0,
  doChecking.ai = FALSE,
  which.stable = c("libstable4u", "stabledist")[1]
)
}
\arguments{
\item{lower}{the vector of lower limits of length n.}

\item{upper}{the vector of upper limits of length n.}

\item{alpha}{default to 1 (Cauchy). Must be 0<alpha<2}

\item{Q}{Shape matrix.  See Nolan (2013).}

\item{delta}{location vector.}

\item{maxpts.pmvnorm}{Defaults to 25000.  Passed to the F_G = pmvnorm() in the integrand of the outermost integral.}

\item{abseps.pmvnorm}{Defaults to 1e-3. Passed to the F_G = pmvnorm() in the integrand of the outermost integral.}

\item{outermost.int}{select which integration function to use for outermost
integral.  Default is "stats::integrate" and one can specify the following options
with the \code{.si} suffix.  For diagonal Q, one can also specify "cubature::adaptIntegrate"
and use the \code{.ai} suffix options below (currently there is a bug for non-diagonal Q).}

\item{subdivisions.si}{the maximum number of subintervals.
The suffix \code{.si} indicates a \code{stats::integrate()}
option for the outermost semi-infinite integral in the product distribution formulation.}

\item{rel.tol.si}{relative accuracy requested.
The suffix \code{.si} indicates a \code{stats::integrate()}
option for the outermost semi-infinite integral in the product distribution formulation.}

\item{abs.tol.si}{absolute accuracy requested. The suffix \code{.si} indicates a \code{stats::integrate()}
option for the outermost semi-infinite integral in the product distribution formulation.}

\item{stop.on.error.si}{logical. If true (the default) an error stops the function.
If false some errors will give a result with a warning in the message component.
The suffix \code{.si} indicates a \code{stats::integrate()}
option for the outermost semi-infinite integral in the product distribution formulation.}

\item{tol.ai}{The maximum tolerance, default 1e-5.
The suffix \code{.ai} indicates a \code{cubature::adaptIntegrate} type
option for the outermost semi-infinite integral in the product distribution formulation.}

\item{fDim.ai}{The dimension of the integrand, default 1, bears no
relation to the dimension of the hypercube
The suffix \code{.ai} indicates a \code{cubature::adaptIntegrate} type
option for the outermost semi-infinite integral in the product distribution formulation.}

\item{maxEval.ai}{The maximum number of function evaluations needed,
default 0 implying no limit
The suffix \code{.ai} indicates a \code{cubature::adaptIntegrate} type
option for the outermost semi-infinite integral in the product distribution formulation.}

\item{absError.ai}{The maximum absolute error tolerated
The suffix \code{.ai} indicates a \code{cubature::adaptIntegrate} type
option for the outermost semi-infinite integral in the product distribution formulation.}

\item{doChecking.ai}{A flag to be thorough checking inputs to
C routines. A FALSE value results in approximately 9 percent speed
gain in our experiments. Your mileage will of course vary. Default
value is FALSE.
The suffix \code{.ai} indicates a \code{cubature::adaptIntegrate} type
option for the outermost semi-infinite integral in the product distribution formulation.}

\item{which.stable}{defaults to "libstable4u", other option is "stabledist".  Indicates which package
should provide the univariate stable distribution in this production distribution form of a univariate
stable and multivariate normal.}
}
\value{
The object returned depends on what is selected for \code{outermost.int}.  In the case of the default,
\code{stats::integrate}, the value is a list of class "integrate" with components:

\item{\code{value}}{ the final estimate of the integral.}
\item{\code{abs.error}}{ estimate of the modulus of the absolute error.}
\item{\code{subdivisions}}{ the number of subintervals produced in the subdivision process.}
\item{\code{message}}{ "OK" or a character string giving the error message.}
\item{\code{call}}{ the matched call.}

Note: The reported \code{abs.error} is likely an under-estimate as \code{integrate}
assumes the integrand was without error,
which is not the case in this application.
}
\description{
Computes the probabilities for the multivariate subgaussian stable
distribution for arbitrary limits, alpha, shape matrices, and
location vectors.
See Nolan (2013).
}
\examples{

## bivariate
U <- c(1,1)
L <- -U
Q <- matrix(c(10,7.5,7.5,10),2)
mvpd::pmvss(L, U, alpha=1.71, Q=Q)

## trivariate
U <- c(1,1,1)
L <- -U
Q <- matrix(c(10,7.5,7.5,7.5,10,7.5,7.5,7.5,10),3)
mvpd::pmvss(L, U, alpha=1.71, Q=Q)

## How `delta` works: same as centering
U <- c(1,1,1)
L <- -U
Q <- matrix(c(10,7.5,7.5,7.5,10,7.5,7.5,7.5,10),3)
D <- c(0.75, 0.65, -0.35)
mvpd::pmvss(L-D, U-D, alpha=1.71, Q=Q)
mvpd::pmvss(L  , U  , alpha=1.71, Q=Q, delta=D)



}
\references{
Nolan JP (2013), \emph{Multivariate elliptically contoured stable distributions:
theory and estimation}. Comput Stat (2013) 28:2067–2089
DOI 10.1007/s00180-013-0396-7
}
\keyword{distribution}
