% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processMonitor.R
\name{processMonitor}
\alias{processMonitor}
\title{Adaptive Process Training}
\usage{
processMonitor(
  data,
  trainObs,
  updateFreq = ceiling(0.5 * trainObs),
  faultsToTriggerAlarm = 5,
  ...
)
}
\arguments{
\item{data}{An xts data matrix}

\item{trainObs}{The number of training observations to be used}

\item{updateFreq}{The number of non-flagged observations to collect before
the function updates. Defaults to half as many observations as the number
of training observations.}

\item{faultsToTriggerAlarm}{The number of sequential faults needed to trigger
an alarm. Defaults to 5.}

\item{...}{Lazy dots for additional internal arguments}
}
\value{
A list with the following components:
  \describe{
    \item{FaultChecks -- }{a class-specific xts flagging matrix with the
      same number of rows as "data". This flag matrix has the following five
      columns:
        \describe{
          \item{SPE -- }{the SPE statistic value for each observation in
            "data"}
          \item{SPE_Flag -- }{a vector of SPE indicators recording 0 if the
            test statistic is less than or equal to the critical value
            passed through from the threshold object}
          \item{T2 -- }{the T2 statistic value for each observation in
            "data"}
          \item{T2_Flag -- }{a vector of T2 fault indicators, defined like
            SPE_Flag}
          \item{Alarm -- }{a column indicating if there have been five flags
            in a row for either the SPE or T2 monitoring statistics or both.
            Alarm states are as follows: 0 = no alarm, 1 = Hotelling's T2
            alarm, 2 = Squared Prediction Error alarm, and 3 = both alarms.}
        }
      }
    \item{Non_Alarmed_Obs -- }{a class-specific xts data matrix of all the
      non-alarmed observations (observations with alarm state equal to 0)}
    \item{Alarms -- }{a class-specific xts data matrix of the features and
      specific alarms of Alarmed observations, where the alarm codes are
      listed above}
    \item{trainSpecs -- }{a threshold object returned by the internal
      threshold() function. See the threshold() function's help file for
      more details.}
  }
}
\description{
Apply Adaptive-Dynamic PCA to state-specific data matrices.
}
\details{
This function is the class-specific implementation of the Adaptive-
  Dynamic PCA described in the details of the mspTrain() function. See
  the mspTrain() function's help file for further details.

  This internal function is called by mspTrain(). This function calls the
  faultFilter() function.
}
\examples{
nrml <- mspProcessData(faults = "NOC")
data <- nrml[nrml[,1] == 1]

processMonitor(data = data[,-1], trainObs = 672)

}
\seealso{
Calls: \code{\link{faultFilter}}. Called by: \code{\link{mspTrain}}.
}
