% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{playFreq}
\alias{playFreq}
\title{Play frequency}
\usage{
playFreq(
  frequency,
  oscillator = "sine",
  duration = rep(1, length(frequency)),
  BPM = 120,
  sample.rate = 44100,
  attack.time = 50,
  inner.release.time = 50,
  plot = FALSE
)
}
\arguments{
\item{frequency}{Numeric, Vector: Frequency / frequencies to play}

\item{oscillator}{String: "sine", "square", "saw". Default = "sine"}

\item{duration}{Float: Note duration in beats. Default = 1}

\item{BPM}{Integer: Beats per minute. Default = 120}

\item{sample.rate}{Integer: Sample rate. Default = 44100}

\item{attack.time}{Integer: Attack time. Default = 50 (Helps prevent popping)}

\item{inner.release.time}{Integer: Release time, that ends on note OFF (instead of beginning at note OFF).
Default = 50 (Also helps prevent popping)}

\item{plot}{Logical: If TRUE, plot waveform}
}
\description{
Play frequency
}
\examples{
\dontrun{
playFreq(440)
}
}
\author{
E.D. Gennatas
}
