% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_signvector.R
\name{step_signvector}
\alias{step_signvector}
\title{Specify a scale's step pattern with a sign vector}
\usage{
step_signvector(set, ineqmat = NULL, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to strings "white," "black", "gray", "roth", "infrared",
"pastel", "rosy", "infrared", or "anaglyph", giving the \code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}},
\code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, \code{\link[=make_gray_ineqmat]{make_gray_ineqmat()}}, \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}}, \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, or \code{\link[=make_anaglyph_ineqmat]{make_anaglyph_ineqmat()}}. For other
arrangements, this parameter accepts explicit matrices.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
A vectors of signs, \code{-1}, \code{0}, and \code{1}, corresponding to the step-related
hyperplanes in the defined \code{ineqmat}.
}
\description{
Rather than calculate the full sign vector from the "modal color" hyperplane
arrangement, sometimes it's advantageous to use a sign vector that reflects
only the pairwise comparisons on a scale's steps. This function does that.
}
\examples{
step_signvector(sc(7, 35)) # Half the length of a full sign vector for heptachords:
signvector(sc(7, 35))

}
