% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{sensitivity_perturb}
\alias{sensitivity_perturb}
\title{Sensitivity to User-Specified Perturbations}
\usage{
sensitivity_perturb(
  model,
  exper,
  perturb,
  nu_seq = NULL,
  n_bootstrap = 100,
  progress = TRUE
)
}
\arguments{
\item{model}{A \code{multimedia} object containing the fitted models for
sensitivity analysis. Note that since our approach relies on correlating
simulated residual error, it is only applicable to models of class
\code{lm_model()}, \code{glmnet_model()} and \code{rf_model()}.}

\item{exper}{The original \code{mediation_data} class object used to fit \code{model}.
These observations will be resampled to support bootstrap confidence
interval construction of the sensitivity curve.}

\item{perturb}{A matrix towards which the original mediator-outcome
covariance should be perturbed. Must have dimension (n_mediators +
n_outcomes) x (n_mediators + n_outcomes).}

\item{nu_seq}{The strength of the perturbation towards the matrix perturb.}

\item{n_bootstrap}{The number of bootstrap resamples used to build confidence
bands around the sensitivity curves. Defaults to 100.}

\item{progress}{A logical indicating whether to show a progress bar.}
}
\value{
A \code{date.frame} giving the outputs of \code{indirect_overall} across many
values of the correlation rho.
}
\description{
The more standard sensitivity and sensitivity_pathwise functions support
sensitivity analysis to violations in assumptions restricted to specific
mediator-outcome pairs. For more general violations, this function allows
arbitrary modification of the default, diagonal covariance matrix structure
across both mediators and outcomes. This makes it possible to ask what
happens when mediators are correlated with one another or when more some
pairs of mediator-outcome pairs have much stronger correlation than others.
}
\details{
Specifically, it defines a new covariance matrix across mediators and
outcomes according to diag(sigma^2_mediator, sigma^2_outcome) + nu * perturb.
The estimates sigma^2 are taken from the residuals in the original mediation
and outcome models, and perturb and nu are provided by the user.
}
\examples{
xy_data <- demo_spline()
exper <- mediation_data(
    xy_data, starts_with("outcome"), "treatment", "mediator"
)
model <- multimedia(
    exper,
    outcome_estimator = glmnet_model(lambda = 1e-2)
) |>
    estimate(exper)
nu_seq <- c(-0.2, 0.2)
perturb <- matrix(
    c(
        0, 3, 0,
        3, 0, 0,
        0, 0, 0
    ),
    nrow = 3, byrow = TRUE
)
sensitivity_perturb(model, exper, perturb, nu_seq, n_bootstrap = 2)
}
