% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_bind.R
\name{metrics_bind}
\alias{metrics_bind}
\title{Metric's data preparation}
\usage{
metrics_bind(
  x,
  data,
  raster = NULL,
  classes = NULL,
  radii = NULL,
  c_level = NULL,
  l_level = NULL,
  ext_raster = NULL,
  show_class_names = FALSE
)
}
\arguments{
\item{x}{An object of class 'MultiLandMetrics' generated with \code{\link[=mland_metrics]{mland_metrics()}}.}

\item{data}{A data.frame with data from each sampling point/site. See Details.}

\item{raster, ext_raster, classes, radii, l_level, c_level}{Parameters to subset data.frame containing the
metrics values. See Details.}

\item{show_class_names}{Logical. If TRUE, classes names will be returned as the names of the classes
previously provided (if so) when \code{x} was generated. Default FALSE.}
}
\value{
A data.frame equal to sampling data provided in \code{data} but with additional columns
containing the values of the metrics for each sampling site.
}
\description{
Merge data.frame with metric's values with a data.frame with other data.
}
\details{
Merges data.frame with metrics values, contained in an object of
class 'MultiLandMetrics' (returned by \code{\link[=mland_metrics]{mland_metrics()}}) with a data.frame with other data for each
site. In this way, the returned data.frame will be prepared for later statistical or
visual analyses. The data.frame provided in \code{data} must have a column named "site" or "point_id",
containing unique identifiers for each sampling site, which must match with the identifiers
present in the data.frame contained in \code{x} (i.e. data.frame with metrics values for each site).
If "site", the function will assume that the site names are provided as identifiers. If "point_id",
the function will assume that point ids are being provided. In any case, these identifiers must
match the site identifiers in \code{x}.

Argument \code{raster}, \code{ext_raster}, \code{classes}, \code{radii}, \code{l_level} and \code{c_level} can be defined to
subset the data.frame contained in \code{x}. In each one of these, an all-positive or an
all-negative vector can be passed, whether to include (all-postive) or exclude (all-negative)
the elements to be taken into account for the subsetting:
\itemize{
\item rasterlayers: a numeric vector with the number of the raster layers to be included/excluded.
For example: \code{c(1, 2, 4)} to include raster layers 1, 2 and 4; \code{c(-2, -3)} to exclude raster layers 2
and 3.
\item classes: must be a list with as many elements as defined raster layers in argument
\code{rasterlayers}. Each element of the list must be a numeric vector (classes identities) with the
classes to be included/excluded. If provided a character vector, \code{\link[=metrics_bind]{metrics_bind()}} assumes that
classes names are provided. For example, for the case with 2 raster layers:
\code{list(c(3, 20, 35), c("Forest", "Crops"))} would include classes 3, 20 and 35 from rasterl ayer 1
and classes "Forest" and "Crops" for raster layer 2. For the case of a unique rasterlayer, there
is no need to input a list. For example, for the case of a unique raster layer and the
exclusion of some classes: \code{c(-5, -10, -15)} to exclude classes 5, 10 and 15 of
the unique raster layer; \code{c("-Forest", "-Grassland")} to exclude classes "Forest" and "Grassland".
Note the "-" before each class name to indicate the exclusion of the classes.
\item radii: a numeric vector to include/exclude particular radii. For example: \code{c(1000, 2000)} to
include only radii of 1000 and 2000 m; \code{c(-500, -1500)} to exclude radii of 500 and 1500 m.
\item c_level: character vector with the class-level metrics to be included/excluded from
the analysis. For example: \code{c("np", "pland")} will include only the metrics "number of patches"
("np") and "percentage of the landscape" ("pland") in the analysis, whereas \code{c("-np", "-pland")}
will exclude them. Note the "-" before each metric name to indicate the exclusion of the
metrics.
\item l_level: character vector with the landscape-level metrics to be included/excluded from
the analysis. Extra calculations for extra raster layers are considered as landscape-level metrics,
and must be provided as "fun_" + the name of the function.
}
}
\examples{
# Get sites names from ed_metrics and creates ad-hoc data.frame with random values of
# "richness" (the response variable). Only for the purpose of this example
sites <- ed_metrics@points$name
sampling_data <- data.frame(site = rep(sites, each = 10),
                            richness = sample(1:500, 150))

# With no filters, all columns with all metrics at all spatial scales are added to
# the sampling data
new_data <- metrics_bind(ed_metrics, sampling_data)

# Subset for metrics of class "Forest", radius 5000 and metric "pland"
new_data <- metrics_bind(ed_metrics, sampling_data, show_class_names = TRUE,
                         classes = "Forest", radii = 3000, c_level = "pland")

# In this format, the data.frame can be passed to a fitting model
fit <- lm(richness ~ r1_Forest_pland_3000, data = new_data)
}
\seealso{
\code{\link[=mland_metrics]{mland_metrics()}}
}
