% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_rast.R
\name{sim_rast}
\alias{sim_rast}
\title{Function to simulate raster surfaces}
\usage{
sim_rast(
  dim = 100,
  resolution = 10,
  autocorr_range1 = NULL,
  autocorr_range2 = NULL,
  sill = 10,
  plot = FALSE,
  user_seed = NULL,
  ...
)
}
\arguments{
\item{dim}{Dimension (number of cells) on a side a square raster (Default = 100)}

\item{resolution}{Resolution of raster cells (Default = 10)}

\item{autocorr_range1}{Optional, Numeric. Spatial correlation range in map cells. Controls the decay of the exponential covariance. If NULL (default), autocorrelation range will be 5\% of specified dimension.}

\item{autocorr_range2}{Optional, Numeric. Spatial correlation range in map cells. Controls the decay of the exponential covariance. If NULL (default), autocorrelation range will be 25\% of specified dimension.}

\item{sill}{Numeric. Variance (partial sill) of the random field (default = 10).}

\item{plot}{Logical. If TRUE, the spatRaster stack will be plotted following the simulation}

\item{user_seed}{Optional seed to replicate simulated surfaces}

\item{...}{Additional arguments. Not currently used}
}
\value{
Four spatRaster surfaces. Two 1/0 binary surfaces and two continuous surfaces.
}
\description{
Function to create four spatRaster surfaces
}
\details{
This is a simple wrapper to create four different raster surfaces. Surfaces differ in the range of autocorrelation. Binary surfaces are created by thresholding continuous values of the Gaussian random surface.
}
\examples{

sim1 <- sim_rast()

sim2 <- sim_rast(dim = 150,
                 resolution = 25)


}
