% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_method.R
\name{plot.multiScaleR}
\alias{plot.multiScaleR}
\title{Plot method for multiScaleR objects}
\usage{
\method{plot}{multiScaleR}(x, ...)
}
\arguments{
\item{x}{An object of class \code{multiScaleR}.}

\item{...}{Arguments to modify the plot. See Details.}
}
\value{
A list of ggplot2 objects.
}
\description{
Plot kernel weight distributions from optimized \code{multiScaleR} objects.
}
\details{
Supported arguments include:
\itemize{
  \item \code{prob}: Cumulative weight cutoff for distance scale (default = 0.9).
  \item \code{scale_dist}: Logical; add vertical line for distance scale (default = TRUE).
  \item \code{add_label}: Logical; annotate scale distance and CI (default = TRUE).
}
}
\examples{
\donttest{
## Using package data
data('pts')
data('count_data')
hab <- terra::rast(system.file('extdata',
                   'hab.tif', package = 'multiScaleR'))

kernel_inputs <- kernel_prep(pts = pts,
                             raster_stack = hab,
                             max_D = 250,
                             kernel = 'gaussian')

mod <- glm(y ~ hab,
           family = poisson,
           data = count_data)

## Optimize scale
opt <- multiScale_optim(fitted_mod = mod,
                        kernel_inputs = kernel_inputs)

plot(opt)

plot(opt, prob = 0.95)

plot(opt, scale_dist = FALSE)

plot(opt, scale_dist = TRUE, add_label = FALSE)
}

}
\seealso{
\code{\link[multiScaleR]{plot_kernel}}
}
