% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like.R
\name{like_CKMR}
\alias{like_CKMR}
\title{Likelihood for CKMR}
\usage{
like_CKMR(n, m, p, type = c("binomial", "poisson"))
}
\arguments{
\item{n}{The number of pairwise comparisons}

\item{m}{The number of kinship matches}

\item{p}{The probability of kinship match}

\item{type}{The statistical distribution for the likelihood calculation}
}
\value{
Numeric representing the log-likelihood.
}
\description{
Returns the log-likelihood for a set of pairwise comparisons. For a parent-offspring pair, a comparison
is defined by the capture year of parent, capture age of parent, and birth year of offspring.
For a half-sibling pair, a comparison is defined by the cohort year of each sibling.
Binomial and Poisson distributions are supported (Conn et al. 2020).
}
\references{
Conn, P.B. et al. 2020. Robustness of close-kin mark-recapture estimators to dispersal
limitation and spatially varying sampling probabilities. Ecol. Evol. 10: 5558-5569. \doi{10.1002/ece3.6296}
}
\seealso{
\code{\link[=calc_POP]{calc_POP()}} \code{\link[=calc_HSP]{calc_HSP()}}
}
