% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R
\name{Snackbar}
\alias{Snackbar}
\title{Snackbar}
\usage{
Snackbar(...)
}
\arguments{
\item{...}{Props to pass to the component.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/snackbar/}
}
\details{
\itemize{
\item action \code{node} \cr Default is - The action to display. It renders after the message, at the end of the snackbar.
\item anchorOrigin \verb{\{ horizontal: 'center'| 'left'| 'right', vertical: 'bottom'| 'top' \}} \cr Default is vertical: 'bottom', horizontal: 'left' The anchor of the Snackbar. On smaller screens, the component grows to occupy all the available width, the horizontal alignment is ignored.
\item autoHideDuration \code{number} \cr Default is null The number of milliseconds to wait before automatically calling the onClose function. onClose should then set the state of the open prop to hide the Snackbar. This behavior is disabled by default with the null value.
\item children \code{element} \cr Default is - Replace the SnackbarContent component.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item ClickAwayListenerProps \code{object} \cr Default is - Props applied to the ClickAwayListener element.Deprecated Use slotProps.clickAwayListener instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item ContentProps \code{object} \cr Default is - Props applied to the SnackbarContent element.Deprecated Use slotProps.content instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item disableWindowBlurListener \code{bool} \cr Default is FALSE If true, the autoHideDuration timer will expire even if the window is not focused.
\item key \code{any} \cr Default is - When displaying multiple consecutive snackbars using a single parent-rendered Snackbar, add the key prop to ensure independent treatment of each message. For instance, use Snackbar key=message. Otherwise, messages might update in place, and features like autoHideDuration could be affected.
\item message \code{node} \cr Default is - The message to display.
\item onClose \code{func} \cr Default is - Callback fired when the component requests to be closed. Typically onClose is used to set state in the parent component, which is used to control the Snackbar open prop. The reason parameter can optionally be used to control the response to onClose, for example ignoring clickaway.Signature:function(event: React.SyntheticEvent | Event, reason: string) = voidevent The event source of the callback.reason Can be: "timeout" (autoHideDuration expired), "clickaway", or "escapeKeyDown".
\item open \code{bool} \cr Default is - If true, the component is shown.
\item resumeHideDuration \code{number} \cr Default is - The number of milliseconds to wait before dismissing after user interaction. If autoHideDuration prop isn't specified, it does nothing. If autoHideDuration prop is specified but resumeHideDuration isn't, we default to autoHideDuration / 2 ms.
\item slotProps \verb{\{ clickAwayListener?: func| \{ children: element, disableReactTree?: bool, mouseEvent?: 'onClick'| 'onMouseDown'| 'onMouseUp'| 'onPointerDown'| 'onPointerUp'| false, onClickAway?: func, touchEvent?: 'onTouchEnd'| 'onTouchStart'| false \}, content?: func| object, root?: func| object, transition?: func| object \}} \cr Default is The props used for each slot inside.
\item slots \verb{\{ clickAwayListener?: elementType, content?: elementType, root?: elementType, transition?: elementType \}} \cr Default is The components used for each slot inside.
\item sx \code{Array} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item TransitionComponent \code{elementType} \cr Default is Grow The component used for the transition. Follow this guide to learn more about the requirements for this component.Deprecated Use slots.transition instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item transitionDuration \verb{number| \{ appear?: number, enter?: number, exit?: number \}} \cr Default is enter: theme.transitions.duration.enteringScreen, exit: theme.transitions.duration.leavingScreen, The duration for the transition, in milliseconds. You may specify a single timeout for all transitions, or individually with an object.
\item TransitionProps \code{object} \cr Default is Props applied to the transition element. By default, the element is based on this Transition component.Deprecated Use slotProps.transition instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
}
}
